/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/08/10 19:42:42
 */
package test.org.asyrinx.joey.gen.model.rdb;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;

import org.apache.commons.beanutils.BeanUtils;
import org.asyrinx.joey.gen.model.rdb.Column;
import org.asyrinx.joey.gen.model.rdb.Index;
import org.asyrinx.joey.gen.model.rdb.IndexEntry;
import org.asyrinx.joey.gen.model.rdb.Table;

import junit.framework.TestCase;

/**
 * @author akima
 */
public class IndexTest extends TestCase {

    public static void main(String[] args) {
        junit.swingui.TestRunner.run(IndexTest.class);
    }

    /*
     * @see TestCase#setUp()
     */
    protected void setUp() throws Exception {
        table = new Table();
        table.setName("sample_table");
        final Column col1 = new Column();
        final Column col2 = new Column();
        final Column col3 = new Column();
        final Column col4 = new Column();
        col1.setName("COL_1");
        col2.setName("COL_2");
        col3.setName("COL_3");
        col4.setName("COL_4");
        table.getColumns().add(col1);
        table.getColumns().add(col2);
        table.getColumns().add(col3);
        table.getColumns().add(col4);
        //
        final Index index1 = new Index();
        index1.setName("index_1");
        table.getIndexes().add(index1);
        final IndexEntry entry1 = new IndexEntry("COL_3");
        final IndexEntry entry2 = new IndexEntry("COL_4");
        index1.add(entry1);
        index1.add(entry2);
    }

    private Table table = null;

    public void testGetColumn() {
        final Index index1 = table.getIndexes().getIndex("index_1");
        final IndexEntry entry1 = index1.getEntry("COL_3");
        final IndexEntry entry2 = index1.getEntry("COL_4");
        final Column col3 = table.getColumns().getColumn("COL_3");
        final Column col4 = table.getColumns().getColumn("COL_4");
        assertEquals(entry1, index1.getEntry("COL_3"));
        assertEquals(entry2, index1.getEntry("COL_4"));
        assertEquals(col3, index1.getEntry("COL_3").getColumn());
        assertEquals(col4, index1.getEntry("COL_4").getColumn());
    }

    public void testBeanUtils() {
        try {
            Map properties = BeanUtils.describe(new IndexEntry());
        } catch (Exception e) {
            e.printStackTrace();
            fail();
            return;
        }
    }

    public void testIndex() {
        table = new Table();
        table.setName("sample_table");
        final Column col1 = new Column(table, "COL_1", "INTEGER");
        final Column col2 = new Column(table, "COL_2", "INTEGER");
        final Column col3 = new Column(table, "COL_3", "INTEGER");
        final Column col4 = new Column(table, "COL_4", "INTEGER");
        //
        final Index index1 = new Index(table, "index_1");
        final IndexEntry entry1 = new IndexEntry(index1, "COL_3");
        final IndexEntry entry2 = new IndexEntry(index1, "COL_4");
        //
        assertEquals(col3, entry1.getColumn());
        assertEquals(col4, entry2.getColumn());
    }

}