/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/08/15 15:03:38
 */
package test.org.asyrinx.joey.gen.model.rdb;

import java.util.ArrayList;
import java.util.List;

import junit.framework.TestCase;

import org.asyrinx.joey.gen.model.rdb.Database;
import org.asyrinx.joey.gen.model.rdb.Databases;
import org.asyrinx.joey.gen.model.rdb.RdbVisitor;
import org.asyrinx.joey.gen.model.rdb.Table;
import org.asyrinx.joey.gen.model.rdb.visitor.RdbVisitorAdapter;
import org.asyrinx.joey.gen.model.rdb.visitor.RdbVisitorMock;
import org.asyrinx.joey.gen.model.rdb.visitor.RdbTopDownVisitor;

/**
 * @author akima
 */
public class RdbVisitorTest extends TestCase {

    public static void main(String[] args) {
        junit.swingui.TestRunner.run(RdbVisitorTest.class);
    }

    public void testVisit() {
        final Databases domain = new Databases("sample");
        final Database db = new Database(domain, "db1");
        db.getTables().add(new Table("table1"));
        db.getTables().add(new Table("table2"));
        //
        final List list = new ArrayList();
        final RdbVisitor visitor = new RdbVisitorMock() {
            public void visit(Databases databases) {
                list.add(databases.getName());
            }

            public void visit(Database database) {
                list.add(database.getName());
            }

            public void visit(Table table) {
                list.add(table.getName());
            }
        };
        new RdbVisitorAdapter(new RdbTopDownVisitor(visitor)).visit(domain);
        //
        assertEquals(4, list.size());
        assertEquals("sample", list.get(0));
        assertEquals("db1", list.get(1));
        assertEquals("table1", list.get(2));
        assertEquals("table2", list.get(3));
    }

}