/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/08/16 1:02:46
 */
package test.org.asyrinx.joey.gen.model.rdb;

import org.asyrinx.joey.gen.model.rdb.Column;
import org.asyrinx.joey.gen.model.rdb.Database;
import org.asyrinx.joey.gen.model.rdb.ForeignKey;
import org.asyrinx.joey.gen.model.rdb.ForeignKeyEntry;
import org.asyrinx.joey.gen.model.rdb.Index;
import org.asyrinx.joey.gen.model.rdb.IndexEntry;
import org.asyrinx.joey.gen.model.rdb.Table;

import junit.framework.TestCase;

/**
 * @author akima
 */
public class TableTest extends TestCase {

    public static void main(String[] args) {
        junit.swingui.TestRunner.run(TableTest.class);
    }

    public void testFindForeignKey() {
        final Database database = new Database();
        final Table table1 = new Table(database, "table1");
        new Column(table1, "col1-1", "int");
        new Column(table1, "col1-2", "int");
        new Column(table1, "col1-3", "int");
        final Index index1_1 = new Index(table1, "named_index_1");
        index1_1.add(new IndexEntry("col1-2"));
        final Index index1_2 = new Index(table1);
        index1_2.add(new IndexEntry("col1-3"));
        index1_2.add(new IndexEntry("col1-1"));
        //
        final Table table2 = new Table(database, "table2");
        new Column(table2, "col2-1", "int");
        new Column(table2, "col2-2", "int");
        new Column(table2, "col2-3", "int");
        final ForeignKey foreignKey2_1 = new ForeignKey(table2, table1.getName());
        foreignKey2_1.add(new ForeignKeyEntry("col2-1", "col1-1"));
        final Index index2_1 = new Index(table2);
        index2_1.add(new IndexEntry("col2-1"));
        foreignKey2_1.setIndex(index2_1);
        final ForeignKey foreignKey2_2 = new ForeignKey("named_fk");
        foreignKey2_2.add(new ForeignKeyEntry("col2-2", "col1-2"));
        foreignKey2_2.add(new ForeignKeyEntry("col2-3", "col1-3"));
        //
        assertEquals(foreignKey2_1, table2.findForeignKey(index2_1));
        assertEquals(index2_1, foreignKey2_1.getIndex());
    }
    
    

}