/*
 * joey-sample1 and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/02/18 16:20:30
 */
package org.asyrinx.joey.entity.dictionary.impl;

import java.util.Iterator;

import org.asyrinx.brownie.core.lang.PropertyUtils;
import org.asyrinx.brownie.core.lang.StringUtils;
import org.asyrinx.brownie.core.query.exp.CompositeExpression;
import org.asyrinx.brownie.core.query.exp.FieldExpression;
import org.asyrinx.brownie.core.query.exp.IExpression;
import org.asyrinx.brownie.core.query.model.Field;
import org.asyrinx.brownie.core.query.model.Table;
import org.asyrinx.joey.entity.dictionary.ConditionBuilder;

/**
 * @author takeshi
 */
public class ConditionBuilderImpl implements ConditionBuilder {

    /**
     *  
     */
    public ConditionBuilderImpl(Table table) {
        super();
        this.table = table;
    }

    protected final Table table;

    public IExpression execute(Object bean) {
        final CompositeExpression result = new CompositeExpression();
        for (Iterator i = table.iterator(); i.hasNext();) {
            final Field field = (Field) i.next();
            final Object value = getProperty(bean, field);
            final IExpression expression = createExpression(bean, value, field);
            if (expression == null)
                continue;
            result.add(expression);
        }
        return result;
    }

    /**
     * @param value
     * @return
     */
    private IExpression createExpression(Object bean, Object value, Field field) {
        if (value == null)
            return null;
        if (value instanceof String) {
            if (StringUtils.isEmpty((String) value))
                return null;
        }
        return new FieldExpression(field, IExpression.EQUAL, value);
    }

    /**
     * @param bean
     * @param propertyName
     * @return
     */
    private Object getProperty(Object bean, Field field) {
        final String propertyName = field.getJavaName();
        try {
            return PropertyUtils.getProperty(bean, propertyName);
        } catch (Exception e) {
            return null;
        }
    }

}