/*
 * joey-rt and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/12/27 15:10:00
 */
package org.asyrinx.joey.entity.service.aspect;

import java.util.List;

import org.aopalliance.intercept.MethodInvocation;
import org.asyrinx.joey.entity.service.util.LogicallyDeletableUtils;
import org.seasar.framework.aop.interceptors.AbstractInterceptor;

/**
 * @author takeshi
 */
public class LogicallyDeletableFilterInterceptor extends AbstractInterceptor {

    public LogicallyDeletableFilterInterceptor(String propertyName) {
        this.propertyName = propertyName;
    }

    private final String propertyName;

    public Object invoke(MethodInvocation invocation) throws Throwable {
        final Object result = invocation.proceed();
        if (result instanceof List) {
            return LogicallyDeletableUtils.filterDeleted((List) result, this.propertyName);
        } else {
            return result;
        }
    }

}