/*
 * joey-rt and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/12/27 15:10:00
 */
package org.asyrinx.joey.entity.service.aspect;

import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.beanutils.MethodUtils;
import org.asyrinx.brownie.core.lang.FieldUtils;
import org.asyrinx.brownie.core.lang.PropertyUtils;
import org.asyrinx.brownie.core.lang.UnsupportedClassRuntimeException;
import org.asyrinx.brownie.core.query.exp.CompositeExpression;
import org.asyrinx.brownie.core.query.exp.FieldExpression;
import org.asyrinx.brownie.core.query.exp.IExpression;
import org.asyrinx.brownie.core.query.model.Field;
import org.asyrinx.brownie.core.query.model.Table;
import org.seasar.framework.aop.interceptors.AbstractInterceptor;

/**
 * @author takeshi
 */
public class LogicallyDeletableSelectInterceptor extends AbstractInterceptor {

    public LogicallyDeletableSelectInterceptor(String propertyName) {
        this.propertyName = propertyName;
    }

    private final String propertyName;

    public Object invoke(MethodInvocation invocation) throws Throwable {
        final Object dao = PropertyUtils.requireProperty(invocation.getThis(), "mainDao", Object.class);
        final Field field = getField(dao);
        final IExpression expression = (IExpression) getExpression(invocation);
        final FieldExpression deletedExpression = new FieldExpression(field.alias(), IExpression.EQUAL, new Boolean(
                false));
        if (expression == null) {
            return MethodUtils.invokeMethod(dao, "select", deletedExpression);
        } else {
            final CompositeExpression composite = new CompositeExpression(IExpression.AND);
            composite.add(expression);
            composite.add(deletedExpression);
            return MethodUtils.invokeMethod(dao, "select", composite);
        }
    }

    /**
     * @param dao
     * @return
     * @throws IllegalArgumentException
     * @throws IllegalAccessException
     * @throws NoSuchFieldException
     */
    private Field getField(Object dao) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException {
        final Object metaModelObj = FieldUtils.getValue(dao, "META_MODEL");
        if (!(metaModelObj instanceof Table))
            throw new UnsupportedClassRuntimeException("field 'META_MODEL' of " + dao + " is not Table");
        final Table metaModel = (Table) metaModelObj;
        final Field field = metaModel.getField(this.propertyName);
        if (field == null)
            throw new UnsupportedOperationException("no field or property '" + propertyName + "'");
        return field;
    }

    /**
     * @param invocation
     * @return
     */
    private Object getExpression(MethodInvocation invocation) {
        final Object[] args = invocation.getArguments();
        if (args.length != 1)
            throw new UnsupportedOperationException("arguments must be one");
        final Object expression = args[0];
        if ((expression != null) && (!(expression instanceof IExpression)))
            throw new UnsupportedOperationException("argument must be a instanceof IExpression");
        return expression;
    }

}