/*
 * joey-rt and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/12/12 0:46:21
 */
package org.asyrinx.joey.entity.service.impl;

import org.asyrinx.brownie.core.collection.ClassKeyHashMap;
import org.asyrinx.brownie.core.collection.ClassKeyMap;
import org.asyrinx.joey.entity.service.EntityServiceDictionary;
import org.seasar.framework.container.S2Container;

/**
 * @author takeshi
 */
public class EntityServiceDictionaryImpl implements EntityServiceDictionary {

    /**
     *  
     */
    public EntityServiceDictionaryImpl() {
        super();
    }

    private final ClassKeyMap classKeyMap = new ClassKeyHashMap();

    public void put(Class entityClass, Class serviceClass) {
        classKeyMap.put(entityClass, serviceClass);
    }

    public void put(Class entityClass, String serviceName) {
        classKeyMap.put(entityClass, serviceName);
    }

    private S2Container container = null;

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.entity.service.EntityServiceDictionary#getService(java.lang.Class)
     */
    public Object getService(Class entityClass) {
        final Object serviceKey = classKeyMap.get(entityClass);
        return getContainer().getComponent(serviceKey);
    }

    public S2Container getContainer() {
        return container;
    }

    public void setContainer(S2Container container) {
        this.container = container;
    }
}