/*
 * joey-rt and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/01/17 14:59:17
 */
package org.asyrinx.joey.entity.service.util;

import java.util.Date;

import org.apache.commons.beanutils.PropertyUtils;
import org.asyrinx.brownie.core.lang.StringUtils;
import org.asyrinx.joey.exception.AppRuntimeException;

/**
 * @author takeshi
 */
public class EntityDateUtils {

    public static final String DEFAULT_PROPERTY_CREATED_DATE = "createdDate";

    public static final String DEFAULT_PROPERTY_UPDATED_DATE = "updatedDate";

    /**
     * GeBeB̐ƍXVݒ肵܂BɂĂ͂łɐݒ肳Ă牽܂B
     * 
     * @param entity
     *            XVΏۂƂȂGeBeB
     * @param createdPropertyName
     *            \Date^vpeBBnullw肳ꂽꍇDEFAULT_PROPERTY_CREATED_DATEg܂B
     * @param updatedPropertyName
     *            XV\Date^vpeBBnullw肳ꂽꍇDEFAULT_PROPERTY_UPDATED_DATEg܂B
     * @param date
     *            nullw肳ꂽꍇAݎgp܂B
     */
    public static void setCreatedAndUpdatedDate(Object entity, String createdPropertyName, String updatedPropertyName,
            Date date) {
        if (date == null)
            date = new Date();
        setCreatedDate(entity, createdPropertyName, date);
        setCreatedDate(entity, updatedPropertyName, date);
    }

    /**
     * GeBeB̐ݒ肵܂Błɐݒ肳Ă牽܂B
     * 
     * @param entity
     *            XVΏۂƂȂGeBeB
     * @param propertyName
     *            \Date^vpeBBnullw肳ꂽꍇDEFAULT_PROPERTY_CREATED_DATEg܂B
     * @param createdDate
     *            Bnullw肳ꂽꍇAݎgp܂B
     */
    public static void setCreatedDate(Object entity, String propertyName, Date createdDate) {
        if (StringUtils.isEmpty(propertyName))
            propertyName = DEFAULT_PROPERTY_CREATED_DATE;
        if (createdDate == null)
            createdDate = new Date();
        try {
            final Object date = PropertyUtils.getProperty(entity, propertyName);
            if (date == null) {
                PropertyUtils.setProperty(entity, propertyName, createdDate);
            }
        } catch (Exception e) {
            throw new AppRuntimeException(e);
        }
    }

    /**
     * GeBeB̍XVݒ肵܂B
     * 
     * @param entity
     *            XVΏۂƂȂGeBeB
     * @param propertyName
     *            XV\Date^vpeBBnullw肳ꂽꍇDEFAULT_PROPERTY_UPDATED_DATEg܂B
     * @param updatedDate
     *            XVBnullw肳ꂽꍇAݎgp܂B
     */
    public static void setUpdatedDate(Object entity, String propertyName, Date updatedDate) {
        if (StringUtils.isEmpty(propertyName))
            propertyName = DEFAULT_PROPERTY_UPDATED_DATE;
        if (updatedDate == null)
            updatedDate = new Date();
        try {
            PropertyUtils.setProperty(entity, propertyName, updatedDate);
        } catch (Exception e) {
            throw new AppRuntimeException(e);
        }
    }

}