/*
 * joey-rt and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/01/17 15:08:43
 */
package org.asyrinx.joey.entity.service.util;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.asyrinx.brownie.core.lang.PropertyUtils;

/**
 * @author takeshi
 */
public class LogicallyDeletableUtils {

    public static final String DEFAULT_PROPERTY_DELETED = "deleted";

    public static List filterDeleted(List list, String propertyName) throws IllegalAccessException,
            InvocationTargetException {
        final List result = new ArrayList();
        for (Iterator i = list.iterator(); i.hasNext();) {
            final Object object = i.next();
            if (!isDeleted(object, propertyName))
                result.add(object);
        }
        return result;
    }

    public static boolean isDeleted(Object entity, String propertyName) throws IllegalAccessException,
            InvocationTargetException {
        final Object deletedPropValue;
        try {
            deletedPropValue = PropertyUtils.getProperty(entity, propertyName);
        } catch (NoSuchMethodException e) {
            return false;
        }
        if (deletedPropValue instanceof Boolean) {
            final Boolean deleted = (Boolean) deletedPropValue;
            return deleted.booleanValue();
        } else {
            return false;
        }
    }

}