/*
 * joey-rt and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/12/15 17:17:44
 */
package org.asyrinx.joey.s2hibernate.filter.impl;

import javax.sql.DataSource;
import javax.transaction.TransactionManager;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.asyrinx.joey.exception.ConfigurationException;
import org.seasar.hibernate.S2Session;
import org.seasar.hibernate.S2SessionFactory;
import org.seasar.hibernate.impl.S2SessionFactoryImpl;

/**
 * @author takeshi
 */
public class S2SessionFactorySurrogateImpl4Test extends S2SessionFactorySurrogateImpl {

    /**
     *  
     */
    public S2SessionFactorySurrogateImpl4Test() {
        super();
    }

    final Log log = LogFactory.getLog(this.getClass());

    public S2Session getSession() {
        final S2Session result = super.getSession();
        if (result != null)
            return result;

        if (!isAllowCreateSession())
            throw new ConfigurationException("ZbVݒ肳Ă܂B",
                    "eXg̏ꍇ́Ahibernate.diconȂǂRequestS2SessionFactoryImpl̃vpeBallowCreateSessiontrueƂݒsƂŃZbV𐶐ł悤ɂȂ܂B"
                            + "eXgȊOɂ̃bZ[W\ꂽꍇAhibernate.dicon, j2ee.dicon, dao.diconȂǂ`FbNĂ");
        log.warn("ZbVݒ肳Ă炸AallowCreateSessiontrueɐݒ肳Ă̂ŁAeXgpɃZbV𐶐܂B"
                + "eXgȊOɂ̃bZ[W\ꂽꍇAhibernate.dicon, j2ee.dicon, dao.diconȂǂ`FbNĂ");
        return getSessionFromFactory();
    }

    private S2SessionFactory factory = null;

    private S2Session lastSession = null;

    private S2Session getSessionFromFactory() {
        if (lastSession == null)
            return newSession();
        if (!lastSession.isOpen())
            return newSession();
        return lastSession;
    }

    private S2Session newSession() {
        if ((transactionManager != null) && (dataSource != null)) {
            if (this.factory == null)
                this.factory = new S2SessionFactoryImpl(transactionManager, dataSource);
            this.lastSession = factory.getSession();
            return lastSession;
        }
        return null;
    }

    private TransactionManager transactionManager;

    private DataSource dataSource;

    public DataSource getDataSource() {
        return dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public TransactionManager getTransactionManager() {
        return transactionManager;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    private boolean allowCreateSession = true;

    public boolean isAllowCreateSession() {
        return allowCreateSession;
    }

    public void setAllowCreateSession(boolean allowCreateSession) {
        this.allowCreateSession = allowCreateSession;
    }
}