/*
 * joey-rt and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/12/13 2:05:16
 */
package org.asyrinx.joey.tapestry.components.entity;

import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IRequestCycle;
import org.asyrinx.brownie.core.lang.ClassUtils;
import org.asyrinx.joey.tapestry.page.EntityPageDictionary;
import org.asyrinx.joey.tapestry.page.IEntityPagingComponent;
import org.asyrinx.joey.tapestry.page.IEntityPagingStrategy;
import org.asyrinx.joey.tapestry.page.impl.EntityPagingStrategyImpl;

/**
 * @author takeshi
 */
public abstract class EntityCreationLink extends AbstractEntityActionLink implements IEntityPagingComponent {

    public abstract EntityPageDictionary getDetailPageDictionary();

    public abstract String getDetailPageDictionaryName();

    public abstract String getDetailPageName();

    private final IEntityPagingStrategy pagingStrategy = new EntityPagingStrategyImpl(this);

    public abstract Class getEntityClass();

    /**
     * @param cycle
     */
    protected void doAction(IRequestCycle cycle) {
        final Object entity = deserialize(cycle);
        pagingStrategy.showEntity(cycle, entity);
    }

    /**
     * @param cycle
     * @return
     */
    protected Object deserialize(IRequestCycle cycle) {
        final Object[] parameters = cycle.getServiceParameters();
        final String entityClassName = (String) parameters[0];
        final Object entity;
        try {
            entity = ClassUtils.newObject(entityClassName, null);
        } catch (InstantiationException e) {
            throw new ApplicationRuntimeException(e);
        }
        return entity;
    }

    protected Object[] serialize() {
        return new Object[] { getEntityClass().getName() };
    }

}