/*
 * joey-rt-test and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/12/15 4:48:07
 */
package org.asyrinx.joey.tapestry.components.entity.table.impl;

import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.asyrinx.joey.tapestry.components.entity.table.IListTableColumn;

/**
 * @author takeshi
 */
public abstract class ListTableHead extends AbstractListTableRow {

    protected void finishLoad() {
        super.finishLoad();
        setCellElement("th");
    }

    public void renderCellContent(IMarkupWriter writer, IRequestCycle cycle) {
        final IListTableColumn columnDef = getColumn();
        setValue(columnDef.getTitle());
        super.renderCellContent(writer, cycle);
    }

    private Object value = null;

    public Object getValue() {
        return value;
    }

    public void setValue(Object value) {
        this.value = value;
    }
    
}