/*
 * joey-rt and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/01/24 18:22:40
 */
package org.asyrinx.joey.tapestry.page.impl;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;

import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.html.BasePage;
import org.asyrinx.brownie.core.lang.ClassUtils;
import org.asyrinx.brownie.core.lang.UnsupportedClassRuntimeException;
import org.asyrinx.brownie.tapestry.page.ReloadablePage;
import org.asyrinx.brownie.validator.MessageLevel;
import org.asyrinx.brownie.validator.ValidationContext;
import org.asyrinx.brownie.validator.ValidationContextFactory;
import org.asyrinx.joey.entity.service.EntityServiceDispatcher;
import org.asyrinx.joey.exception.AppValidationRuntimeException;
import org.asyrinx.joey.tapestry.page.CaptionablePage;
import org.asyrinx.joey.tapestry.page.DetailView;

/**
 * @author takeshi
 */
public abstract class BaseEditPage extends BasePage implements DetailView, CaptionablePage,
        ReloadablePage {

    public abstract String getPageCaption();

    public abstract Class getTargetClass();

    public abstract EntityServiceDispatcher getEntityServiceDispatcher();

    public abstract ValidationContextFactory getValidationContextFactory();

    /*
     * (non-Javadoc)
     * 
     * @see org.apache.tapestry.AbstractPage#renderPage(org.apache.tapestry.IMarkupWriter,
     *      org.apache.tapestry.IRequestCycle)
     */
    public void renderPage(IMarkupWriter writer, IRequestCycle cycle) {
        checkTarget(getTarget());
        super.renderPage(writer, cycle);
    }

    private void checkTarget(Object bean) {
        final Class class1 = getTargetClass();
        if (class1 == null)
            return;
        if (!class1.isInstance(bean))
            throw new UnsupportedClassRuntimeException("Illegal target bean. Target must be '"
                    + class1.getName() + "': bean + " + bean);
    }

    private Object targetObject = null;

    public Object getTargetObject() {
        return this.targetObject;
    }

    public void setTargetObject(Object bean) {
        this.targetObject = bean;
        validationContext = null;
    }

    public Object getTarget() {
        return getTargetObject();
    }

    public void setTarget(Object bean) {
        setTargetObject(bean);
    }

    public void addInfo(String message) {
        if (this.validationContext == null)
            this.validationContext = getValidationContextFactory().createContext();
        this.validationContext.addMessage(message, MessageLevel.INFO);
    }

    public void addError(String message) {
        if (this.validationContext == null)
            this.validationContext = getValidationContextFactory().createContext();
        this.validationContext.addMessage(message, MessageLevel.INFO);
    }

    public void clickSave(IRequestCycle cycle) {
        if (getTarget() == null)
            return;
        validationContext = null;
        try {
            getEntityServiceDispatcher().save(getTarget());
            addInfo("o^ɐ܂");
        } catch (AppValidationRuntimeException e) {
            this.validationContext = e.getContext();
            addError("o^Ɏs܂");
        } catch (Exception e) {
            addError("o^Ɏs܂");
        }
    }

    private ValidationContext validationContext = null;

    public void reload() {
        if (getTarget() == null)
            return;
        validationContext = null;
        final Object pk;
        try {
            pk = getTargetPk();
            addInfo("f[^[h܂");
        } catch (Exception e) {
            addError("L[̎擾Ɏs܂B");
            return;
        }
        final Object loaded;
        try {
            loaded = getEntityServiceDispatcher().load(getTargetClass(), (Serializable) pk);
        } catch (Exception e) {
            addError("ǂݍ݂Ɏs܂Bpk=" + pk + " class" + getTargetClass().getName());
            return;
        }
        setTarget(loaded);
    }

    /**
     * @return
     * @throws NoSuchMethodException
     * @throws InvocationTargetException
     * @throws IllegalAccessException
     */
    private Object getTargetPk() throws IllegalAccessException, InvocationTargetException,
            NoSuchMethodException {
        return PropertyUtils.getProperty(getTarget(), "primaryKey");
    }

    public void clickReload(IRequestCycle cycle) {
        reload();
    }

    public void clickCreateNew(IRequestCycle cycle) {
        final Object newObj;
        try {
            newObj = ClassUtils.newObject(getTargetClass(), null);
            addInfo("VKf[^쐬܂Bo^ł܂B");
        } catch (Exception e) {
            addError("VIuWFNg̐Ɏs܂B class" + getTargetClass().getName());
            return;
        }
        setTarget(newObj);
    }

    public void clickCreateCopy(IRequestCycle cycle) {
        final Object target = getTarget();
        if (target == null)
            return;
        if (target instanceof Cloneable) {
            Object newObj;
            try {
                newObj = MethodUtils.invokeExactMethod(target, "clone", null);
                addInfo("Rs[܂BύXēo^ł܂B");
            } catch (Exception e) {
                addError("IuWFNg̃Rs[Ɏs܂B class" + getTargetClass().getName() + " object="
                        + target);
                return;
            }
            setTarget(newObj);
        }
    }

    public ValidationContext getValidationContext() {
        return validationContext;
    }

}