/*
 * joey-rt and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/01/24 19:02:23
 */
package org.asyrinx.joey.tapestry.page.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.html.BasePage;
import org.asyrinx.brownie.core.query.exp.IExpression;
import org.asyrinx.brownie.tapestry.page.ReloadablePage;
import org.asyrinx.joey.entity.service.EntityServiceDispatcher;
import org.asyrinx.joey.tapestry.page.CaptionablePage;

/**
 * @author takeshi
 */
public abstract class BaseListPage extends BasePage implements CaptionablePage, ReloadablePage {

    public abstract String getPageCaption();

    public abstract EntityServiceDispatcher getEntityServiceDispatcher();

    public abstract Class getTargetClass();

    private List targets = null;

    public List getTargets() {
        return this.targets;
    }

    public void setTargets(List targets) {
        this.targets = targets;
    }

    private IExpression condition = null;

    public IExpression getCondition() {
        return this.condition;
    }

    public void setCondition(IExpression condition) {
        this.condition = condition;
    }

    private boolean searchClicked = false;

    public void clickSearch(IRequestCycle cycle) {
        loadTargets();
        searchClicked = true;
    }

    public void loadTargets() {
        final List results = getEntityServiceDispatcher().select(getTargetClass(), getCondition());
        setTargets(results);
        if (isDeleteDuplicates())
            doDeleteDuplicates();
    }

    private void doDeleteDuplicates() {
        final List result = new ArrayList();
        for (Iterator i = getTargets().iterator(); i.hasNext();) {
            final Object object = i.next();
            if (!result.contains(object))
                result.add(object);
        }
        setTargets(result);
    }

    public void renderPage(IMarkupWriter writer, IRequestCycle cycle) {
        if (!searchClicked)
            loadTargets();
        super.renderPage(writer, cycle);
        searchClicked = false;
    }

    public void reload() {
        loadTargets();
    }

    private boolean deleteDuplicates = true;

    public boolean isDeleteDuplicates() {
        return deleteDuplicates;
    }

    public void setDeleteDuplicates(boolean deleteDuplicates) {
        this.deleteDuplicates = deleteDuplicates;
    }
}