/*
 * joey-rt and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/01/17 15:12:17
 */
package test.org.asyrinx.joey.entity.service.util;

import java.util.ArrayList;
import java.util.List;

import org.asyrinx.joey.entity.service.util.LogicallyDeletableUtils;

import junit.framework.TestCase;

/**
 * @author takeshi
 */
public class LogicallyDeletableUtilsTest extends TestCase {

    public static void main(String[] args) {
        junit.swingui.TestRunner.run(LogicallyDeletableUtilsTest.class);
    }

    public void testFilterDeleted() {
        final A a1 = new A("a1");
        final A a2 = new A("deleted");
        final B b1 = new B("b1", false);
        final B b2 = new B("b2", true);
        final C c1 = new C("c1", null);
        final C c2 = new C("c2", new Boolean(false));
        final C c3 = new C("c3", new Boolean(true));
        final D d1 = new D("d1", null);
        final D d2 = new D("d2", "");
        final D d3 = new D("d3", "false");
        final D d4 = new D("d3", "true");
        final D d5 = new D("d3", "deleted");
        final D d6 = new D("d3", "zzzzz");
        //
        final List list = new ArrayList();
        list.add(a1);
        list.add(a2);
        list.add(b1);
        list.add(b2);
        list.add(c1);
        list.add(c2);
        list.add(c3);
        list.add(d1);
        list.add(d2);
        list.add(d3);
        list.add(d4);
        list.add(d5);
        list.add(d6);
        //
        final List filtered;
        try {
            filtered = LogicallyDeletableUtils.filterDeleted(list, "deleted");
        } catch (Exception e) {
            e.printStackTrace();
            fail();
            return;
        }
        assertEquals(11, filtered.size());
        assertEquals(0, filtered.indexOf(a1));
        assertEquals(1, filtered.indexOf(a2));
        assertEquals(2, filtered.indexOf(b1));
        assertEquals(-1, filtered.indexOf(b2));
        assertEquals(3, filtered.indexOf(c1));
        assertEquals(4, filtered.indexOf(c2));
        assertEquals(-1, filtered.indexOf(c3));
        assertEquals(5, filtered.indexOf(d1));
        assertEquals(6, filtered.indexOf(d2));
        assertEquals(7, filtered.indexOf(d3));
        assertEquals(8, filtered.indexOf(d4));
        assertEquals(9, filtered.indexOf(d5));
        assertEquals(10, filtered.indexOf(d6));
    }

    public void testIsDeleted() {
        final A a1 = new A("a1");
        final A a2 = new A("deleted");
        final B b1 = new B("b1", false);
        final B b2 = new B("b2", true);
        final C c1 = new C("c1", null);
        final C c2 = new C("c2", new Boolean(false));
        final C c3 = new C("c3", new Boolean(true));
        final D d1 = new D("d1", null);
        final D d2 = new D("d2", "");
        final D d3 = new D("d3", "false");
        final D d4 = new D("d3", "true");
        final D d5 = new D("d3", "deleted");
        final D d6 = new D("d3", "zzzzz");
        try {
            assertEquals(false, LogicallyDeletableUtils.isDeleted(a1, "value"));
            //ldeletedǁAvpeBƂĂ݂͑Ȃ
            assertEquals(false, LogicallyDeletableUtils.isDeleted(a2, "deleted"));
            assertEquals(false, LogicallyDeletableUtils.isDeleted(a2, "xxxx"));
            //
            assertEquals(false, LogicallyDeletableUtils.isDeleted(b1, "deleted"));
            assertEquals(true, LogicallyDeletableUtils.isDeleted(b2, "deleted"));
            assertEquals(false, LogicallyDeletableUtils.isDeleted(b1, "value"));
            assertEquals(false, LogicallyDeletableUtils.isDeleted(b2, "value"));
            assertEquals(false, LogicallyDeletableUtils.isDeleted(b1, "xxxx"));
            assertEquals(false, LogicallyDeletableUtils.isDeleted(b2, "xxxx"));
            //
            assertEquals(false, LogicallyDeletableUtils.isDeleted(c1, "deleted"));
            assertEquals(false, LogicallyDeletableUtils.isDeleted(c2, "deleted"));
            assertEquals(true, LogicallyDeletableUtils.isDeleted(c3, "deleted"));
            assertEquals(false, LogicallyDeletableUtils.isDeleted(c1, "value"));
            assertEquals(false, LogicallyDeletableUtils.isDeleted(c2, "value"));
            assertEquals(false, LogicallyDeletableUtils.isDeleted(c3, "value"));
            assertEquals(false, LogicallyDeletableUtils.isDeleted(c1, "xxxx"));
            assertEquals(false, LogicallyDeletableUtils.isDeleted(c2, "xxxx"));
            assertEquals(false, LogicallyDeletableUtils.isDeleted(c3, "xxxx"));
            //D̓vpeB"deleted"Abooleanł͂ȂStringȂ̂ŁA
            assertEquals(false, LogicallyDeletableUtils.isDeleted(d1, "deleted"));
            assertEquals(false, LogicallyDeletableUtils.isDeleted(d2, "deleted"));
            assertEquals(false, LogicallyDeletableUtils.isDeleted(d3, "deleted"));
            assertEquals(false, LogicallyDeletableUtils.isDeleted(d4, "deleted"));
            assertEquals(false, LogicallyDeletableUtils.isDeleted(d5, "deleted"));
            assertEquals(false, LogicallyDeletableUtils.isDeleted(d6, "deleted"));
        } catch (Exception e) {
            e.printStackTrace();
            fail();
            return;
        }
    }

    public static class A {
        public A(String value) {
            this.value = value;
        }

        private String value = null;

        public String getValue() {
            return value;
        }
    }

    public static class B extends A {
        public B(String value, boolean deleted) {
            super(value);
            this.deleted = deleted;
        }

        private boolean deleted = false;

        public boolean isDeleted() {
            return deleted;
        }
    }

    public static class C extends A {
        public C(String value, Boolean deleted) {
            super(value);
            this.deleted = deleted;
        }

        private Boolean deleted = null;

        public Boolean getDeleted() {
            return deleted;
        }
    }

    public static class D extends A {
        public D(String value, String deleted) {
            super(value);
            this.deleted = deleted;
        }

        private String deleted = null;

        public String getDeleted() {
            return deleted;
        }
    }

}