/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.entity.service;

import org.asyrinx.brownie.validator.MessageLevel;
import org.asyrinx.brownie.validator.ValidationContext;
import org.asyrinx.brownie.validator.ValidationContextFactory;
import org.asyrinx.brownie.validator.Validator;
import org.asyrinx.joey.entity.service.EntityService;
import org.asyrinx.joey.entity.service.ValidatorDictionary;
import org.asyrinx.joey.exception.AppValidationException;
import org.asyrinx.joey.exception.AppValidationRuntimeException;

public abstract class AbstractEntityService
implements EntityService {
    private MessageLevel exceptionLevel = MessageLevel.ERROR;
    private ValidatorDictionary validatorDictionary = null;
    private boolean validateBeforeSave = true;
    private ValidationContextFactory validationContextFactory = null;

    public abstract Class getEntityClass();

    public void validate(Object obj) throws AppValidationException {
        ValidationContext context = this.createValidationContext();
        this.validate(obj, context);
        if (!context.getMatters().isEmpty()) {
            throw new AppValidationException(context);
        }
    }

    public void validate(Object obj, ValidationContext context) {
        this.validateByValidator(context, obj);
        this.validateUnique(context, obj);
    }

    public void validateByValidator(ValidationContext context, Object obj) {
        ValidatorDictionary dictionary = this.getValidatorDictionary();
        Class<?> current = obj.getClass();
        while (current != null) {
            Validator validator = dictionary.getValidator(current);
            if (validator != null) {
                validator.evaluate(context, obj);
            }
            current = current.getSuperclass();
        }
    }

    public abstract void validateUnique(ValidationContext var1, Object var2);

    public boolean checkUnique(Object obj) {
        ValidationContext context = this.createValidationContext();
        this.validateUnique(context, obj);
        return context.getMessages().isEmpty();
    }

    protected ValidationContext createValidationContext() {
        return this.getValidationContextFactory().createContext();
    }

    public ValidatorDictionary getValidatorDictionary() {
        return this.validatorDictionary;
    }

    public void setValidatorDictionary(ValidatorDictionary validatorDictionary) {
        this.validatorDictionary = validatorDictionary;
    }

    public boolean isValidateBeforeSave() {
        return this.validateBeforeSave;
    }

    public void setValidateBeforeSave(boolean validateBeforeSave) {
        this.validateBeforeSave = validateBeforeSave;
    }

    protected void doBeforeSave(Object obj) {
        if (!this.isValidateBeforeSave()) {
            return;
        }
        try {
            this.validate(obj);
        }
        catch (AppValidationException e) {
            throw new AppValidationRuntimeException(e.getContext(), (Throwable)((Object)e));
        }
    }

    public MessageLevel getExceptionLevel() {
        return this.exceptionLevel;
    }

    public void setExceptionLevel(MessageLevel exceptionLevel) {
        this.exceptionLevel = exceptionLevel;
    }

    public ValidationContextFactory getValidationContextFactory() {
        return this.validationContextFactory;
    }

    public void setValidationContextFactory(ValidationContextFactory validationContextFactory) {
        this.validationContextFactory = validationContextFactory;
    }
}

