/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.tapestry.components.entity;

import java.io.Serializable;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IRequestCycle;
import org.asyrinx.joey.tapestry.components.entity.AbstractEntityActionLink;

public abstract class AbstractEntityInstanceActionLink
extends AbstractEntityActionLink {
    private IBinding _entityBinding = null;

    public Object getEntity() {
        IBinding aEntityBinding = this.getEntityBinding();
        if (aEntityBinding != null) {
            return aEntityBinding.getObject();
        }
        return null;
    }

    public IBinding getEntityBinding() {
        return this._entityBinding;
    }

    public void setEntityBinding(IBinding entityBinding) {
        this._entityBinding = entityBinding;
    }

    public abstract Class getEntityClass();

    public abstract Serializable getEntityPrimaryKey();

    public abstract String getKeyPropertyName();

    public Object deserialize(IRequestCycle cycle) {
        Class<?> entityClass;
        Object[] parameters = cycle.getServiceParameters();
        String entityClassName = (String)parameters[0];
        Serializable pk = (Serializable)parameters[1];
        try {
            entityClass = Class.forName(entityClassName);
        }
        catch (ClassNotFoundException e) {
            throw new ApplicationRuntimeException("Class not found. '" + entityClassName + "'.");
        }
        Object entity = this.getDispatcher().get(entityClass, pk);
        return entity;
    }

    private Serializable getPrimaryKey(Object entity) {
        try {
            return (Serializable)PropertyUtils.getProperty((Object)entity, (String)this.getKeyPropertyName());
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("couldn't get property value '" + this.getKeyPropertyName() + "'.");
        }
    }

    public Object[] serialize() {
        IBinding aEntityBinding = this.getEntityBinding();
        if (aEntityBinding != null) {
            Object aEntity = aEntityBinding.getObject();
            if (aEntity != null) {
                return new Object[]{aEntity.getClass().getName(), this.getPrimaryKey(aEntity)};
            }
            return null;
        }
        if (this.getEntityClass() != null) {
            if (this.getEntityPrimaryKey() != null) {
                return new Object[]{this.getEntityClass().getName(), this.getEntityPrimaryKey()};
            }
            return null;
        }
        if (this.getEntityClass() == null) {
            throw new ApplicationRuntimeException("entityClass was null");
        }
        throw new ApplicationRuntimeException("entityPrimaryKey was null");
    }
}

