/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.tapestry.valid.impl;

import java.util.Iterator;
import org.apache.tapestry.valid.IValidator;
import org.asyrinx.brownie.tapestry.valid.StringFieldValidator;
import org.asyrinx.brownie.validator.ValidationContextFactory;
import org.asyrinx.brownie.validator.Validator;
import org.asyrinx.brownie.validator.ValidatorRuntimeException;
import org.asyrinx.brownie.validator.impl.CompositeValidator;
import org.asyrinx.brownie.validator.prop.PropertyValidator;
import org.asyrinx.brownie.validator.prop.StringField;
import org.asyrinx.joey.entity.service.ValidatorDictionary;
import org.asyrinx.joey.tapestry.valid.ValidatorFactory;

public class ValidatorFactoryImpl
implements ValidatorFactory {
    private final ValidatorDictionary dictionary;
    private final ValidationContextFactory contextFactory;
    private boolean checkOnBlur = false;
    private boolean checkOnSubmit = true;

    public ValidatorFactoryImpl(ValidatorDictionary dictionary, ValidationContextFactory contextFactory) {
        this.dictionary = dictionary;
        this.contextFactory = contextFactory;
    }

    public IValidator getValidator(Class entityClass, String propertyName) {
        PropertyValidator propValidator = this.getPropertyValidator(entityClass, propertyName);
        if (propValidator == null) {
            throw this.createNotFound(entityClass, propertyName);
        }
        if (propValidator instanceof StringField) {
            return this.createStringFieldValidator((StringField)propValidator);
        }
        throw this.createNotFound(entityClass, propertyName);
    }

    private StringFieldValidator createStringFieldValidator(StringField stringField) {
        StringFieldValidator result = new StringFieldValidator(stringField);
        result.setContextFactory(this.contextFactory);
        result.setCheckOnBlur(this.isCheckOnBlur());
        result.setCheckOnSubmit(this.isCheckOnSubmit());
        return result;
    }

    private ValidatorRuntimeException createNotFound(Class entityClass, String propertyName) {
        return new ValidatorRuntimeException("validator not fount for " + entityClass.getName() + "#" + propertyName);
    }

    private PropertyValidator getPropertyValidator(Class entityClass, String propertyName) {
        Validator validator = this.dictionary.getValidator(entityClass);
        if (validator == null) {
            return null;
        }
        if (validator instanceof PropertyValidator) {
            return (PropertyValidator)validator;
        }
        if (!(validator instanceof CompositeValidator)) {
            return null;
        }
        CompositeValidator compositeValidator = (CompositeValidator)validator;
        Iterator i = compositeValidator.iterator();
        while (i.hasNext()) {
            PropertyValidator sf;
            Validator v = (Validator)i.next();
            if (!(v instanceof PropertyValidator) || !(sf = (PropertyValidator)v).getPropertyName().equals(propertyName)) continue;
            return sf;
        }
        return null;
    }

    public boolean isCheckOnBlur() {
        return this.checkOnBlur;
    }

    public void setCheckOnBlur(boolean checkOnBlur) {
        this.checkOnBlur = checkOnBlur;
    }

    public boolean isCheckOnSubmit() {
        return this.checkOnSubmit;
    }

    public void setCheckOnSubmit(boolean checkOnSubmit) {
        this.checkOnSubmit = checkOnSubmit;
    }
}

