/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.collection;

import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections.ArrayStack;
import org.apache.commons.collections.Closure;

public abstract class MapTreeVisitor {
    protected final Map root;
    private Closure closure;
    protected final ArrayStack keyStack = new ArrayStack();

    public MapTreeVisitor(Map root, Closure closure) {
        this.root = root;
        this.closure = closure;
    }

    public MapTreeVisitor(Map root) {
        this(root, null);
    }

    public void execute() {
        this.keyStack.clear();
        this.doOnMap(this.root);
    }

    public void doOnMap(Map map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object var5_5;
            Object key = iterator.next();
            Object value = map.get(key);
            this.keyStack.push(key);
            try {
                if (value instanceof Map) {
                    this.doOnMap((Map)value);
                } else {
                    this.doOnLeaf(value);
                }
            }
            catch (Throwable throwable) {
                var5_5 = null;
                this.keyStack.pop();
                throw throwable;
            }
            var5_5 = null;
            this.keyStack.pop();
        }
    }

    public void doOnLeaf(Object value) {
        if (this.closure != null) {
            this.closure.execute(value);
        }
    }

    public Closure getClosure() {
        return this.closure;
    }
}

