/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.io;

import java.io.File;

public abstract class FileWatchdog
extends Thread {
    public static final long DEFAULT_DELAY = 60000L;
    protected long delay = 60000L;
    private final File file;
    private long lastModified = 0L;
    private boolean warnedAlready = false;
    private boolean interrupted = false;

    protected FileWatchdog(String filename) {
        this(filename, 60000L);
    }

    protected FileWatchdog(String filename, long delay_msec) {
        this.file = new File(filename);
        this.delay = delay_msec;
        this.setDaemon(true);
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    protected abstract void doOnChange();

    public void checkAndConfigure() {
        boolean fileExists;
        try {
            fileExists = this.file.exists();
        }
        catch (SecurityException e) {
            System.err.println("Was not allowed to read check file existance, file:[" + this.file.getAbsolutePath() + "].");
            this.interrupted = true;
            return;
        }
        if (fileExists) {
            long l = this.file.lastModified();
            if (l > this.lastModified) {
                this.lastModified = l;
                this.doOnChange();
                this.warnedAlready = false;
            }
        } else if (!this.warnedAlready) {
            System.err.println("[" + this.file.getAbsolutePath() + "] does not exist.");
            this.warnedAlready = true;
        }
    }

    public void run() {
        while (!this.interrupted) {
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.checkAndConfigure();
        }
    }
}

