/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.lang;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.asyrinx.brownie.core.lang.ObjectUtils;
import org.asyrinx.brownie.core.lang.UnsupportedClassRuntimeException;

public final class ArrayUtils
extends org.apache.commons.lang.ArrayUtils {
    public static boolean equals(Object[] array1, Object[] array2) {
        if (array1 == array2) {
            return true;
        }
        if (ObjectUtils.eitherIsNull(array1, array2)) {
            return false;
        }
        if (array1.length != array2.length) {
            return false;
        }
        int i = 0;
        while (i < array1.length) {
            if (!org.apache.commons.lang.ObjectUtils.equals((Object)array1[i], (Object)array2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void addToList(List dest, Object[] objects) {
        int i = 0;
        while (i < objects.length) {
            dest.add(objects[i]);
            ++i;
        }
    }

    public static ArrayList toArrayList(Object[] objects) {
        ArrayList result = new ArrayList();
        ArrayUtils.addToList(result, objects);
        return result;
    }

    public static Vector toVector(Object[] objects) {
        Vector result = new Vector();
        ArrayUtils.addToList(result, objects);
        return result;
    }

    public static Object getFirst(Object[] objects) {
        if (objects == null) {
            return null;
        }
        if (objects.length == 0) {
            return null;
        }
        return objects[0];
    }

    public static Object getLast(Object[] objects) {
        if (objects == null) {
            return null;
        }
        if (objects.length == 0) {
            return null;
        }
        return objects[objects.length - 1];
    }

    public static String[] toStringArray(Collection sources) {
        String[] result = new String[sources.size()];
        Iterator iterator = sources.iterator();
        int idx = 0;
        while (iterator.hasNext()) {
            Object element = iterator.next();
            result[idx] = element != null ? element.toString() : null;
            ++idx;
        }
        return result;
    }

    public static String[] toStringArray(Object[] sources) {
        String[] result = new String[sources.length];
        int idx = 0;
        while (idx < sources.length) {
            result[idx] = sources[idx] != null ? sources[idx].toString() : null;
            ++idx;
        }
        return result;
    }

    public static Object[] subArray(Object[] source, int beginIdx, int length) {
        if (source == null) {
            return null;
        }
        Object[] result = new Object[length];
        for (int i = beginIdx; i <= source.length - 1 && i - beginIdx <= result.length - 1; ++i) {
            result[i - beginIdx] = source[i];
        }
        return result;
    }

    public static char[] toPrimitive(Character[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return org.apache.commons.lang.ArrayUtils.EMPTY_CHAR_ARRAY;
        }
        char[] result = new char[array.length];
        int i = 0;
        while (i < array.length) {
            result[i] = array[i].charValue();
            ++i;
        }
        return result;
    }

    public static Character[] toObject(char[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return org.apache.commons.lang.ArrayUtils.EMPTY_CHARACTER_OBJECT_ARRAY;
        }
        Character[] result = new Character[array.length];
        int i = 0;
        while (i < array.length) {
            result[i] = new Character(array[i]);
            ++i;
        }
        return result;
    }

    public static Object[] toObjectArray(Object primitiveArray) {
        if (primitiveArray instanceof boolean[]) {
            return org.apache.commons.lang.ArrayUtils.toObject((boolean[])((boolean[])primitiveArray));
        }
        if (primitiveArray instanceof byte[]) {
            return org.apache.commons.lang.ArrayUtils.toObject((byte[])((byte[])primitiveArray));
        }
        if (primitiveArray instanceof short[]) {
            return org.apache.commons.lang.ArrayUtils.toObject((short[])((short[])primitiveArray));
        }
        if (primitiveArray instanceof int[]) {
            return org.apache.commons.lang.ArrayUtils.toObject((int[])((int[])primitiveArray));
        }
        if (primitiveArray instanceof long[]) {
            return org.apache.commons.lang.ArrayUtils.toObject((long[])((long[])primitiveArray));
        }
        if (primitiveArray instanceof double[]) {
            return org.apache.commons.lang.ArrayUtils.toObject((double[])((double[])primitiveArray));
        }
        if (primitiveArray instanceof float[]) {
            return org.apache.commons.lang.ArrayUtils.toObject((float[])((float[])primitiveArray));
        }
        if (primitiveArray instanceof char[]) {
            return ArrayUtils.toObject((char[])primitiveArray);
        }
        throw new UnsupportedClassRuntimeException(primitiveArray.getClass().getName());
    }

    public static Object toPrimitiveArray(Object[] objectArray) {
        if (objectArray instanceof Boolean[]) {
            return org.apache.commons.lang.ArrayUtils.toPrimitive((Boolean[])((Boolean[])objectArray));
        }
        if (objectArray instanceof Byte[]) {
            return org.apache.commons.lang.ArrayUtils.toPrimitive((Byte[])((Byte[])objectArray));
        }
        if (objectArray instanceof Short[]) {
            return org.apache.commons.lang.ArrayUtils.toPrimitive((Short[])((Short[])objectArray));
        }
        if (objectArray instanceof Integer[]) {
            return org.apache.commons.lang.ArrayUtils.toPrimitive((Integer[])((Integer[])objectArray));
        }
        if (objectArray instanceof Long[]) {
            return org.apache.commons.lang.ArrayUtils.toPrimitive((Long[])((Long[])objectArray));
        }
        if (objectArray instanceof Double[]) {
            return org.apache.commons.lang.ArrayUtils.toPrimitive((Double[])((Double[])objectArray));
        }
        if (objectArray instanceof Float[]) {
            return org.apache.commons.lang.ArrayUtils.toPrimitive((Float[])((Float[])objectArray));
        }
        if (objectArray instanceof Character[]) {
            return ArrayUtils.toPrimitive((Character[])objectArray);
        }
        throw new UnsupportedClassRuntimeException(objectArray.getClass().getName());
    }
}

