/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.sql;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.asyrinx.brownie.core.lang.StringUtils;
import org.asyrinx.brownie.core.sql.Elements;
import org.asyrinx.brownie.core.sql.IBuilder;
import org.asyrinx.brownie.core.sql.Operator;
import org.asyrinx.brownie.core.util.DateRange;
import org.asyrinx.brownie.core.util.DateUtils;

public class Conditions
extends Elements {
    private Operator connection = Operator.AND;
    private DateFormat defaultDateFormat = new SimpleDateFormat();

    public Conditions(IBuilder builder) {
        super(builder);
    }

    public Operator getConnection() {
        return this.connection;
    }

    public void setConnection(Operator operator) {
        this.connection = operator;
    }

    public Conditions addNewCondition() {
        return this.addNewCondition(this.getConnection());
    }

    public Conditions addNewCondition(Operator connection) {
        Conditions result = new Conditions(this.builder);
        result.setConnection(connection);
        super.addImpl(result);
        return result;
    }

    public Conditions add(String condition) {
        super.addImpl(condition);
        return this;
    }

    public Conditions addAsString(String field, String value) {
        return this.add(field, value, Operator.EQUAL);
    }

    public Conditions add(String field, String value, Operator operater) {
        return this.add(field, value, operater, true);
    }

    public Conditions add(String field, String value, Operator operater, boolean quote) {
        super.addImpl(this.builder.buildCondition(field, value, operater, quote));
        return this;
    }

    public Conditions add(String field, int value) {
        return this.add(field, value, Operator.EQUAL);
    }

    public Conditions add(String field, int value, Operator operater) {
        return this.add(field, String.valueOf(value), operater, false);
    }

    public Conditions add(String field, long value) {
        return this.add(field, value, Operator.EQUAL);
    }

    public Conditions add(String field, long value, Operator operater) {
        return this.add(field, String.valueOf(value), operater, false);
    }

    public Conditions add(String field, Date value) {
        return this.add(field, value, Operator.EQUAL);
    }

    public Conditions add(String field, Date value, Operator operater) {
        return this.add(field, value, operater, this.defaultDateFormat);
    }

    public Conditions add(String field, Date value, DateFormat dateFormat) {
        return this.add(field, value, Operator.EQUAL, dateFormat);
    }

    public Conditions add(String field, Date value, Operator operater, DateFormat dateFormat) {
        return this.add(field, dateFormat.format(value), operater);
    }

    public Conditions addPeriod(String field, DateRange period) {
        return this.addPeriod(field, period.getFrom(), period.getTo());
    }

    public Conditions addPeriod(String field, Date from, Date to) {
        return this.addPeriod(field, from, to, true);
    }

    public Conditions addPeriod(String field, Date from, Date to, boolean adust) {
        return this.addPeriod(field, from, to, adust, this.defaultDateFormat);
    }

    public Conditions addPeriod(String field, Date from, Date to, boolean adust, DateFormat dateFormat) {
        if (adust) {
            if (from != null) {
                from = DateUtils.adjustDateBegin(from);
            }
            if (to != null) {
                to = DateUtils.adjustDateEnd(to);
            }
        }
        return this.addPeriod(field, from == null ? null : dateFormat.format(from), to == null ? null : dateFormat.format(to));
    }

    public Conditions addPeriod(String field, String from, String to) {
        if (!StringUtils.isAvailable(field)) {
            return this;
        }
        if (StringUtils.isAvailable(from)) {
            this.add(field, from, Operator.GREATER_EQUAL);
        }
        if (StringUtils.isAvailable(to)) {
            this.add(field, to, Operator.LESS_EQUAL);
        }
        return this;
    }
}

