/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.servlet;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.asyrinx.brownie.core.lang.ArrayUtils;
import org.asyrinx.brownie.core.lang.StringUtils;

public final class ServletUtils {
    private ServletUtils() {
    }

    public static Map parametersToMap(ServletConfig config) {
        HashMap<String, String> result = new HashMap<String, String>();
        Enumeration enumeration = config.getInitParameterNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            result.put(key, config.getInitParameter(key));
        }
        return result;
    }

    public static Map parametersToMap(ServletContext context) {
        HashMap<String, String> result = new HashMap<String, String>();
        Enumeration enumeration = context.getInitParameterNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            result.put(key, context.getInitParameter(key));
        }
        return result;
    }

    public static Map attributesToMap(ServletContext context) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Enumeration enumeration = context.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            result.put(key, context.getAttribute(key));
        }
        return result;
    }

    public static Map attributesToMap(HttpSession session) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Enumeration enumeration = session.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            result.put(key, session.getAttribute(key));
        }
        return result;
    }

    public static Map attributesToMap(HttpServletRequest req) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Enumeration enumeration = req.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            result.put(key, req.getAttribute(key));
        }
        return result;
    }

    public static Map parametersToMap(HttpServletRequest req) {
        HashMap<String, String> result = new HashMap<String, String>();
        Enumeration enumeration = req.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String data = req.getParameter(key);
            result.put(key, data);
        }
        return result;
    }

    public static Map headerToMap(HttpServletRequest req) {
        HashMap<String, String> result = new HashMap<String, String>();
        Enumeration enumeration = req.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String data = req.getHeader(key);
            result.put(key, data);
        }
        return result;
    }

    public static String reqToStr(HttpServletRequest req) {
        StringBuffer result = new StringBuffer();
        result.append("\nUri=" + req.getRequestURI());
        result.append("\nMethod=" + req.getMethod());
        result.append("\nParameters=" + ServletUtils.parametersToMap(req));
        result.append("\nAttributes=" + ServletUtils.attributesToMap(req));
        result.append("\nQueryString=" + req.getQueryString());
        result.append("\nHeaders=" + ServletUtils.headerToMap(req));
        result.append("\nPathInfo=" + req.getPathInfo());
        result.append("\nPathTranslated=" + req.getPathTranslated());
        result.append("\nRequestedSessionId=" + req.getRequestedSessionId());
        result.append("\nRemoteAddr=" + req.getRemoteAddr());
        result.append("\nRemoteHost=" + req.getRemoteHost());
        result.append("\nRemoteUser=" + req.getRemoteUser());
        result.append("\nSession=" + req.getSession());
        result.append("\nScheme=" + req.getScheme());
        result.append("\nServerName=" + req.getServerName());
        result.append("\nServerPort=" + req.getServerPort());
        result.append("\nServletPath=" + req.getServletPath());
        result.append("\nCookies=" + ArrayUtils.toArrayList(req.getCookies()));
        result.append("\nEncoding=" + req.getCharacterEncoding());
        result.append("\nAuthType=" + req.getAuthType());
        return result.toString();
    }

    public static void setNoCache(HttpServletResponse res) {
        res.setHeader("Pragma", "no-chace");
        res.setHeader("Cahce-Control", "no-store");
        long lngCurrentTm = System.currentTimeMillis();
        long lngValidTm = 300000L;
        res.setDateHeader("Expires", lngCurrentTm + lngValidTm);
    }

    public static String getFullURL(HttpServletRequest req) {
        Enumeration enumPrms = req.getParameterNames();
        String params = "";
        while (enumPrms.hasMoreElements()) {
            String paramName = (String)enumPrms.nextElement();
            if (StringUtils.isAvailable(params)) {
                params = String.valueOf(params) + "&";
            }
            params = String.valueOf(params) + paramName + "=" + StringUtils.nullTrim(req.getParameter(paramName));
        }
        String result = req.getRequestURI();
        if (StringUtils.isAvailable(params)) {
            return String.valueOf(result) + "?" + params;
        }
        return result;
    }
}

