/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.tapestry.components.link;

import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.IScript;
import org.apache.tapestry.IScriptProcessor;
import org.apache.tapestry.components.ILinkComponent;
import org.apache.tapestry.engine.ILink;
import org.apache.tapestry.html.Body;
import org.apache.tapestry.link.ILinkRenderer;
import org.asyrinx.brownie.tapestry.components.link.AbstractScriptLinkRenderer;
import org.asyrinx.brownie.tapestry.components.link.IWindowOpenOption;
import org.asyrinx.brownie.tapestry.util.ValueTagWriter;

public class WindowOpenLinkRenderer
extends AbstractScriptLinkRenderer {
    public static final ILinkRenderer SHARED_INSTANCE = new WindowOpenLinkRenderer();
    public static final String CLICK_LINK_ROW_METHOD_NAME = "clickLink";
    private static final String HREF_DUMMY = "javascript:void(0);";
    public static final String SYM_METHOD_CLICK_ROW = "clickLinkMethodName";
    public static final String SYM_OPTIONS = "options";

    public WindowOpenLinkRenderer() {
        super("WindowOpenLinkRenderer.script");
    }

    protected void checkBeforeRender(IRequestCycle cycle, ILinkComponent linkComponent) {
        super.checkBeforeRender(cycle, linkComponent);
        if (!(linkComponent instanceof IWindowOpenOption)) {
            throw new ApplicationRuntimeException("must-be-implemented-IWindowOpenOption", (Object)this, null, null);
        }
    }

    protected void addScript(IRequestCycle cycle, IScript script, Body body) {
        HashMap<String, String> symbols = new HashMap<String, String>();
        symbols.put(SYM_METHOD_CLICK_ROW, CLICK_LINK_ROW_METHOD_NAME);
        script.execute(cycle, (IScriptProcessor)body, symbols);
    }

    protected void renderBeginTag(IMarkupWriter writer, IRequestCycle cycle, ILinkComponent linkComponent) {
        if (this.getHasBody()) {
            writer.begin(this.getElement());
        } else {
            writer.beginEmpty(this.getElement());
        }
        writer.attribute("href", HREF_DUMMY);
        writer.attribute("onclick", "clickLink(this)");
    }

    protected void renderBody(IMarkupWriter bodyWriter, IRequestCycle cycle, ILinkComponent linkComponent) {
        ILink l = linkComponent.getLink(cycle);
        bodyWriter.println();
        WindowOpenLinkRenderer.addIdValueSpan(bodyWriter, "href", this.constructURL(l, linkComponent.getAnchor()));
        IWindowOpenOption option = (IWindowOpenOption)linkComponent;
        WindowOpenLinkRenderer.addIdValueSpan(bodyWriter, "target", option.getWindowTarget());
        bodyWriter.println();
        bodyWriter.begin("span");
        bodyWriter.attribute("id", SYM_OPTIONS);
        bodyWriter.attribute("style", "display:none");
        bodyWriter.println();
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("toolbar", option.getWindowToolbar());
        options.put("location", option.getWindowLocation());
        options.put("directories", option.getWindowDirectories());
        options.put("status", option.getWindowStatus());
        options.put("menubar", option.getWindowMenubar());
        options.put("scrollbars", option.getWindowScrollbars());
        options.put("resizable", option.getWindowResizable());
        options.put("width", option.getWindowWidth());
        options.put("height", option.getWindowHeight());
        options.put("left", option.getWindowLeft());
        options.put("top", option.getWindowTop());
        IMarkupWriter nestedWriter = bodyWriter.getNestedWriter();
        ValueTagWriter tagWriter = new ValueTagWriter(nestedWriter);
        tagWriter.addProperties(options);
        nestedWriter.close();
        bodyWriter.end();
    }

    private static void addIdValueSpan(IMarkupWriter writer, String id, String value) {
        if (StringUtils.isEmpty((String)value)) {
            return;
        }
        writer.begin("span");
        writer.attribute("id", id);
        writer.attribute("style", "display:none");
        IMarkupWriter innerDivWriter = writer.getNestedWriter();
        innerDivWriter.printRaw(value);
        innerDivWriter.close();
        writer.end();
    }

    private String getElement() {
        return "a";
    }
}

