/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/02/07
 */
package org.asyrinx.joey.gen.model;

import org.apache.commons.lang.ArrayUtils;

/**
 * @author akima
 */
public class FieldTypeImpl implements IFieldType {

	/**
	 * 
	 */
	public FieldTypeImpl(IProperty property) {
		super();
		this.property = property;
	}

	private final IProperty property;

	/**
	 * @return
	 */
	private Object getTorqueType() {
		return property.getTorqueType();
	}

	/**
	 * @return
	 */
	private WmEnum getEnum() {
		return property.getEnum();
	}

	private static final String[] TYPE_TEXT_FIELDS =
		new String[] { "CHAR", "VARCHAR", };
	private static final String[] TYPE_MEMO_FIELDS =
		new String[] { "LONGVARCHAR", "CLOB", };
	private static final String[] TYPE_DATE_FIELDS =
		new String[] { "DATE", "TIME", "TIMESTAMP", };

	private static final String[] TYPE_BOOLEAN_FIELDS = new String[] { "BIT", };

	private static final String[] TYPE_NUMBER_FIELDS =
		new String[] {
			"NUMERIC",
			"DECIMAL",
			"TINYINT",
			"SMALLINT",
			"INTEGER",
			"BIGINT",
			"REAL",
			"FLOAT",
			"DOUBLE",
			};

	public boolean isTextFieldType() {
		return ArrayUtils.indexOf(TYPE_TEXT_FIELDS, this.getTorqueType()) > -1;
	}

	public boolean isMemoFieldType() {
		return ArrayUtils.indexOf(TYPE_MEMO_FIELDS, this.getTorqueType()) > -1;
	}

	public boolean isBooleanFieldType() {
		return ArrayUtils.indexOf(TYPE_BOOLEAN_FIELDS, this.getTorqueType())
			> -1;
	}

	public boolean isDateFieldType() {
		return ArrayUtils.indexOf(TYPE_DATE_FIELDS, this.getTorqueType()) > -1;
	}

	public boolean isNumberFieldType() {
		return ArrayUtils.indexOf(TYPE_NUMBER_FIELDS, this.getTorqueType())
			> -1;
	}

	public boolean isSelectFieldType() {
		return getEnum() != null;
	}

}
