/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/01/27
 */
package org.asyrinx.joey.gen.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * @author akima
 */
public class WmEnum implements Cloneable, IElement {

	/**
	 * 
	 */
	public WmEnum() {
		super();
	}

	public void accept(IVisitor visitor) {
		visitor.visit(this);
	}
	/**
	 * @see java.lang.Object#clone()
	 */
	public Object clone() throws CloneNotSupportedException {
		final WmEnum result = (WmEnum) super.clone();
		final Iterator iterator = entries.iterator();
		while (iterator.hasNext()) {
			final WmEnumEntry entry = (WmEnumEntry) iterator.next();
			result.addEntry((WmEnumEntry) entry.clone());
		}
		return result;
	}

	/**
	 * @see org.asyrinx.brownie.windmill.model.IElement#finishLoad()
	 */
	public void finishLoad() {
	}

	private WmDatabase database = null;
	private final List entries = new ArrayList();

	/**
	 * @see org.apache.torque.engine.database.model.Table#addUnique(org.xml.sax.Attributes)
	 */
	public void addEntry(WmEnumEntry entry) {
		entry.setEnum(this);
		entries.add(entry);
	}

	public List getEntries() {
		return entries;
	}

	public boolean isPrimitiveValueType() {
		return TypeNameUtils.toClassName(getValueType()) != null;
	}

	public String getValueClass() {
		final String result = TypeNameUtils.toClassName(getValueType());
		if (result != null)
			return result;
		else
			return getValueType();
	}

	private String name = null;
	private String label = null;
	private String valueType = null;

	/**
	 * @return
	 */
	public String getLabel() {
		return label;
	}

	/**
	 * @return
	 */
	public String getName() {
		return name;
	}

	/**
	 * @param string
	 */
	public void setLabel(String string) {
		label = string;
	}

	/**
	 * @param string
	 */
	public void setName(String string) {
		name = string;
	}

	/**
	 * @return
	 */
	public String getValueType() {
		return valueType;
	}

	/**
	 * @param string
	 */
	public void setValueType(String string) {
		valueType = string;
	}

	/**
	 * @return
	 */
	public WmDatabase getDatabase() {
		return database;
	}

	/**
	 * @param table
	 */
	public void setDatabase(WmDatabase database) {
		this.database = database;
	}

}
