/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/01/27
 */
package org.asyrinx.joey.gen.model;

import java.util.Iterator;

import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.torque.engine.database.model.Column;
import org.apache.torque.engine.database.model.ForeignKey;

/**
 * @author akima
 */
public class WmForeignKey extends ForeignKey implements Cloneable, IElement {

	/**
	 * 
	 */
	public WmForeignKey() {
		super();
	}

	public void accept(IVisitor visitor) {
		visitor.visit(this);
	}

	/**
	 * @see org.apache.torque.engine.database.model.ForeignKey#toString()
	 */
	public String toString() {
		return ObjectUtils.identityToString(this);
	}

	/**
	 * @see java.lang.Object#clone()
	 */
	public Object clone() throws CloneNotSupportedException {
		return super.clone();
	}

	/**
	 * @see org.asyrinx.brownie.windmill.model.IElement#finishLoad()
	 */
	public void finishLoad() {
		setOnUpdate(normalizeFKey(getOnUpdate()));
		setOnDelete(normalizeFKey(getOnDelete()));
	}

	protected static final String NONE = "NONE";
	protected static final String SETNULL = "SETNULL";

	/**
	 * Normalizes the input of onDelete, onUpdate attributes
	 *
	 * @param attrib the attribute to normalize
	 * @return nomalized form
	 */
	protected final String normalizeFKey(String attrib) {
		if (attrib == null)
			attrib = NONE;
		attrib = attrib.toUpperCase();
		if (attrib.equals(SETNULL))
			attrib = "SET NULL";
		return attrib;
	}

	/**
	 * Returns whether or not the onUpdate attribute is set
	 *
	 * @return true if the onUpdate attribute is set
	 */
	public boolean hasOnUpdate() {
		return !StringUtils.equals(getOnUpdate(), NONE);
	}

	/**
	 * Returns whether or not the onDelete attribute is set
	 *
	 * @return true if the onDelete attribute is set
	 */
	public boolean hasOnDelete() {
		return !StringUtils.equals(getOnDelete(), NONE);
	}

	public WmTable getLocalTableObject() {
		return (WmTable) getTable();
	}

	public WmTable getForeignTableObject() {
		return (WmTable) getTable().getDatabase().getTable(
			this.getForeignTableName());
	}

	public String getPropertyNameInReferred(boolean plural) {
		//	#foreach ($fk in $table.Referrers)
		//	  #set ( $tblFK = $fk.Table )
		//	  #if ( !($tblFK.Name.equals($table.Name)) )
		//	  #set ( $className = $tblFK.JavaName )
		//	  #set ( $relatedByCol = "" )
		final String className = getTable().getJavaName();
		String relatedByCol = "";
		//	  #foreach ($columnName in $fk.LocalColumns)
		//		#set ( $column = $tblFK.getColumn($columnName) )
		//		#if ($column.isMultipleFK())
		//		  #set ($relatedByCol= "$relatedByCol$column.JavaName")
		//		#end
		//	  #end
		final Iterator localColNameIter = getLocalColumns().iterator();
		while (localColNameIter.hasNext()) {
			final String localColName = (String) localColNameIter.next();
			final Column localCol = getTable().getColumn(localColName);
			if (localCol.isMultipleFK())
				relatedByCol = relatedByCol + localCol.getJavaName();
		}
		//	#if ($relatedByCol == "")
		//	  #set ( $suffix = "" )
		//	  #set ( $relCol = "${className}s" )
		//	  #set ( $relColMs = $className )
		//	#else
		//	  #set ( $suffix = "RelatedBy$relatedByCol" )
		//	  #set ( $relCol= "${className}sRelatedBy$relatedByCol" )
		//	  #set ( $relColMs= "${className}RelatedBy$relatedByCol" )
		//	#end
		if (StringUtils.isEmpty(relatedByCol)) {
			if (plural)
				return StringUtils.uncapitalize(className + "s");
			else
				return StringUtils.uncapitalize(className);
		} else {
			if (plural)
				return StringUtils.uncapitalize(
					className + "sRelatedBy" + relatedByCol);
			else
				return StringUtils.uncapitalize(
					className + "RelatedBy" + relatedByCol);
		}
	}

	public String getPropertyNameInReferred() {
		return getPropertyNameInReferred(true);
	}

	public String getPropertyNameInLocal() {
		//#foreach ($fk in $table.ForeignKeys)
		//
		//  #set ( $tblFK = $table.Database.getTable($fk.ForeignTableName) )
		//  #set ( $className = $tblFK.JavaName )
		//  #set ( $relCol = "" )

		final WmTable foreignTable = getForeignTableObject();
		final String className = foreignTable.getJavaName();
		String relCol = "";

		//  #foreach ($columnName in $fk.LocalColumns)
		//	#set ( $column = $table.getColumn($columnName) )
		//	#if ($column.isMultipleFK() || $fk.ForeignTableName.equals($table.Name))
		//	  #set ( $relCol = "$relCol$column.JavaName" )
		//	#end
		//  #end
		final Iterator localColNameIter = getLocalColumns().iterator();
		while (localColNameIter.hasNext()) {
			final String localColName = (String) localColNameIter.next();
			final Column localCol = getTable().getColumn(localColName);
			if (localCol.isMultipleFK()
				|| getForeignTableName().equals(getTable().getName()))
				relCol = relCol + localCol.getJavaName();
		}

		//  #if ($relCol != "")
		//	#set ( $relCol = "RelatedBy$relCol" )
		//  #end
		if (StringUtils.isNotEmpty(relCol))
			relCol = "RelatedBy" + relCol;

		//  #set ( $pVarName = "$className$relCol" )
		return StringUtils.uncapitalize(className + relCol);
	}

	/**
	 * @return
	 */
	public String getForeignTable() {
		return super.getForeignTableName();
	}

	/**
	 * @param string
	 */
	public void setForeignTable(String string) {
		super.setForeignTableName(string);
	}

	private String label = null;

	/**
	 * @return
	 */
	public String getLabel() {
		if (StringUtils.isEmpty(this.label))
			return this.getName();
		else
			return label;
	}

	/**
	 * @param string
	 */
	public void setLabel(String string) {
		label = string;
	}

	private boolean navigatable = true;

	/**
	 * @return
	 */
	public boolean isNavigatable() {
		return navigatable;
	}

	/**
	 * @param b
	 */
	public void setNavigatable(boolean b) {
		navigatable = b;
	}

	private boolean oneToOne = false;

	/**
	 * @return
	 */
	public boolean isOneToOne() {
		return oneToOne;
	}

	/**
	 * @param b
	 */
	public void setOneToOne(boolean b) {
		oneToOne = b;
	}

}
