/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/01/27
 */
package org.asyrinx.joey.gen.model;

import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.engine.EngineException;
import org.apache.torque.engine.database.model.Index;
import org.apache.torque.engine.database.model.Table;
import org.asyrinx.brownie.core.lang.ObjectUtils;

/**
 * @author akima
 */
public class WmIndex extends Index implements Cloneable, IElement {

	/**
	 * 
	 */
	public WmIndex() {
		super();
	}

	public void accept(IVisitor visitor) {
		visitor.visit(this);
	}

	/**
	 * @see org.apache.torque.engine.database.model.Index#toString()
	 */
	public String toString() {
		return ObjectUtils.identityToString(this);
	}

	/**
	 * @see org.asyrinx.brownie.windmill.model.IElement#finishLoad()
	 */
	public void finishLoad() {
	}

	/**
	 * @see java.lang.Object#clone()
	 */
	public Object clone() throws CloneNotSupportedException {
		return super.clone();
	}
	/**
	 * @param table
	 * @param indexColumns
	 * @throws org.apache.torque.engine.EngineException
	 */
	public WmIndex(Table table, List indexColumns) throws EngineException {
		super(table, indexColumns);
	}

	Log log = LogFactory.getLog(this.getClass());

	public void addColumn(String columnName) {
		log.debug("addColumn was called: " + columnName);
		getColumns().add(columnName);
	}

	private String label = null;

	/**
	 * @return
	 */
	public String getLabel() {
		if (StringUtils.isEmpty(this.label))
			return this.getName();
		else
			return label;
	}

	/**
	 * @param string
	 */
	public void setLabel(String string) {
		label = string;
	}

}
