/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/02/07
 */
package org.asyrinx.joey.gen.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.lang.exception.NestableRuntimeException;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

/**
 * @author akima
 */
public class WmTableAspect extends WmTable {

	/**
	 * 
	 */
	public WmTableAspect() {
		super();
	}

	/**
	 * @param name
	 */
	public WmTableAspect(String name) {
		super(name);
	}

	public void accept(IVisitor visitor) {
		visitor.visit(this);
	}

	/**
	 * @see java.lang.Object#clone()
	 */
	public Object clone() throws CloneNotSupportedException {
		return super.clone();
	}

	private final List includeTableNamePatterns = new ArrayList();
	private final List excludeTableNamePatterns = new ArrayList();

	public void addInclude(String tableNamePattern) {
		includeTableNamePatterns.add(tableNamePattern);
	}

	public void addExclude(String tableNamePattern) {
		excludeTableNamePatterns.add(tableNamePattern);
	}

	private boolean matches(Iterator patternIterator, String tableName) {
		while (patternIterator.hasNext()) {
			final String patternStr = (String) patternIterator.next();
			if ("*".equals(patternStr))
				return true;
			try {
				final RE re = new RE(patternStr);
				final boolean result = re.match(tableName);
				if (result)
					return true;
			} catch (RESyntaxException e) {
				throw new NestableRuntimeException(
					"Syntax Error:" + patternStr,
					e);
			}
		}
		return false;
	}

	private boolean isIncluded(String tableName) {
		return matches(includeTableNamePatterns.iterator(), tableName);
	}

	private boolean isExcluded(String tableName) {
		return matches(excludeTableNamePatterns.iterator(), tableName);
	}

	private boolean isTarget(WmTable table) {
		final String tableName = table.getName();
		if (isIncluded(tableName))
			return !isExcluded(tableName);
		else
			return false;
	}

	public void apply() {
		final Iterator iterator =
			IteratorUtils.arrayIterator(getDatabase().getTables());
		while (iterator.hasNext()) {
			final WmTable table = (WmTable) iterator.next();
			if (!isTarget(table))
				continue;
			copy(table);
		}
	}

	public void copy(WmTable dest) {
		try {
			final Iterator colIter =
				IteratorUtils.arrayIterator(this.getColumns());
			while (colIter.hasNext()) {
				final WmColumn col = (WmColumn) colIter.next();
				dest.addColumn((WmColumn) col.clone());
			}
			final Iterator indexIter =
				IteratorUtils.arrayIterator(this.getIndices());
			while (indexIter.hasNext()) {
				final WmIndex index = (WmIndex) indexIter.next();
				dest.addIndex((WmIndex) index.clone());
			}
			final Iterator fkIter =
				IteratorUtils.arrayIterator(this.getForeignKeys());
			while (fkIter.hasNext()) {
				final WmForeignKey fk = (WmForeignKey) fkIter.next();
				dest.addForeignKey((WmForeignKey) fk.clone());
			}
			final Iterator uniqIter =
				IteratorUtils.arrayIterator(this.getUnices());
			while (uniqIter.hasNext()) {
				final WmUnique unique = (WmUnique) uniqIter.next();
				dest.addUnique((WmUnique) unique.clone());
			}
			final Iterator arefIter = this.getAspectRefs().iterator();
			while (arefIter.hasNext()) {
				final WmAspectRef aspectRef = (WmAspectRef) arefIter.next();
				dest.addAspectRef((WmAspectRef) aspectRef.clone());
			}
			final Iterator joinIter = this.getJoins().iterator();
			while (joinIter.hasNext()) {
				final WmJoin join = (WmJoin) joinIter.next();
				dest.addJoin((WmJoin) join.clone());
			}
		} catch (CloneNotSupportedException e) {
			throw new NestableRuntimeException(e);
		}
	}

}
