/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/01/29
 */
package org.asyrinx.joey.gen.model.visitor;

import org.asyrinx.joey.gen.model.IVisitor;
import org.asyrinx.joey.gen.model.WmAppData;
import org.asyrinx.joey.gen.model.WmAspect;
import org.asyrinx.joey.gen.model.WmAspectAction;
import org.asyrinx.joey.gen.model.WmAspectRef;
import org.asyrinx.joey.gen.model.WmColumn;
import org.asyrinx.joey.gen.model.WmColumnFormat;
import org.asyrinx.joey.gen.model.WmDatabase;
import org.asyrinx.joey.gen.model.WmEnum;
import org.asyrinx.joey.gen.model.WmEnumEntry;
import org.asyrinx.joey.gen.model.WmForeignKey;
import org.asyrinx.joey.gen.model.WmIdMethodParameter;
import org.asyrinx.joey.gen.model.WmIndex;
import org.asyrinx.joey.gen.model.WmInheritance;
import org.asyrinx.joey.gen.model.WmJoin;
import org.asyrinx.joey.gen.model.WmProperty;
import org.asyrinx.joey.gen.model.WmTable;
import org.asyrinx.joey.gen.model.WmTableAspect;
import org.asyrinx.joey.gen.model.WmUnique;

/**
 * @author akima
 */
public class BottomUpVisitor extends VisitorWrapper {

	/**
	 * @param wrapped
	 */
	public BottomUpVisitor(IVisitor wrapped) {
		super(wrapped);
	}

	/**
	 * @see org.asyrinx.brownie.windmill.model.IVisitor#visit(org.asyrinx.brownie.windmill.model.WmAppData)
	 */
	public void visit(WmAppData appData) {
		super.visit(appData);
	}

	/**
	 * @see org.asyrinx.brownie.windmill.model.IVisitor#visit(org.asyrinx.brownie.windmill.model.WmAspect)
	 */
	public void visit(WmAspect aspect) {
		super.visit(aspect);
		aspect.getDatabase().accept(this);
	}

	/**
	 * @see org.asyrinx.brownie.windmill.model.IVisitor#visit(org.asyrinx.brownie.windmill.model.WmAspectAction)
	 */
	public void visit(WmAspectAction aspectAction) {
		super.visit(aspectAction);
		aspectAction.getAspect().accept(this);
	}

	/**
	 * @see org.asyrinx.brownie.windmill.model.IVisitor#visit(org.asyrinx.brownie.windmill.model.WmAspectRef)
	 */
	public void visit(WmAspectRef aspectRef) {
		super.visit(aspectRef);
		aspectRef.getTable().accept(this);
	}

	/**
	 * @see org.asyrinx.brownie.windmill.model.IVisitor#visit(org.asyrinx.brownie.windmill.model.WmColumn)
	 */
	public void visit(WmColumn column) {
		super.visit(column);
		((WmTable) column.getTable()).accept(this);
	}

	/**
	 * @see org.asyrinx.brownie.windmill.model.visitor.VisitorWrapper#visit(org.asyrinx.brownie.windmill.model.WmColumnFormat)
	 */
	public void visit(WmColumnFormat format) {
		super.visit(format);

	}

	/**
	 * @see org.asyrinx.brownie.windmill.model.IVisitor#visit(org.asyrinx.brownie.windmill.model.WmDatabase)
	 */
	public void visit(WmDatabase database) {
		super.visit(database);
		((WmAppData) database.getAppData()).accept(this);
	}

	/**
	 * @see org.asyrinx.brownie.windmill.model.IVisitor#visit(org.asyrinx.brownie.windmill.model.WmEnum)
	 */
	public void visit(WmEnum enum) {
		super.visit(enum);
		enum.getDatabase().accept(this);
	}

	/**
	 * @see org.asyrinx.brownie.windmill.model.IVisitor#visit(org.asyrinx.brownie.windmill.model.WmEnumEntry)
	 */
	public void visit(WmEnumEntry enumEntry) {
		super.visit(enumEntry);
		enumEntry.getEnum().accept(this);
	}

	/**
	 * @see org.asyrinx.brownie.windmill.model.IVisitor#visit(org.asyrinx.brownie.windmill.model.WmForeignKey)
	 */
	public void visit(WmForeignKey foreignKey) {
		super.visit(foreignKey);
		((WmTable) foreignKey.getTable()).accept(this);
	}

	/**
	 * @see org.asyrinx.brownie.windmill.model.IVisitor#visit(org.asyrinx.brownie.windmill.model.WmIdMethodParameter)
	 */
	public void visit(WmIdMethodParameter idMethodParameter) {
		super.visit(idMethodParameter);
		((WmTable) idMethodParameter.getTable()).accept(this);
	}

	/**
	 * @see org.asyrinx.brownie.windmill.model.IVisitor#visit(org.asyrinx.brownie.windmill.model.WmIndex)
	 */
	public void visit(WmIndex index) {
		super.visit(index);
		((WmTable) index.getTable()).accept(this);
	}

	/**
	 * @see org.asyrinx.brownie.windmill.model.IVisitor#visit(org.asyrinx.brownie.windmill.model.WmInheritance)
	 */
	public void visit(WmInheritance inheritance) {
		super.visit(inheritance);
		((WmColumn) inheritance.getColumn()).accept(this);
	}

	/**
	 * @see org.asyrinx.brownie.windmill.model.IVisitor#visit(org.asyrinx.brownie.windmill.model.WmJoin)
	 */
	public void visit(WmJoin join) {
		super.visit(join);
		if (join.getParent() != null)
			join.getParent().accept(this);
		else if (join.getParentTable() != null)
			join.getParentTable().accept(this);
	}

	/**
	 * @see org.asyrinx.brownie.windmill.model.IVisitor#visit(org.asyrinx.brownie.windmill.model.WmProperty)
	 */
	public void visit(WmProperty property) {
		super.visit(property);
		((WmColumn) property.getColumn()).accept(this);
	}

	/**
	 * @see org.asyrinx.brownie.windmill.model.IVisitor#visit(org.asyrinx.brownie.windmill.model.WmTable)
	 */
	public void visit(WmTable table) {
		super.visit(table);
		((WmDatabase) table.getDatabase()).accept(this);
	}

	/**
	 * @see org.asyrinx.brownie.windmill.model.visitor.VisitorWrapper#visit(org.asyrinx.brownie.windmill.model.WmTableAspect)
	 */
	public void visit(WmTableAspect tableAspect) {
		super.visit(tableAspect);
		((WmDatabase) tableAspect.getDatabase()).accept(this);
	}

	/**
	 * @see org.asyrinx.brownie.windmill.model.IVisitor#visit(org.asyrinx.brownie.windmill.model.WmUnique)
	 */
	public void visit(WmUnique unique) {
		super.visit(unique);
		((WmTable) unique.getTable()).accept(this);
	}

}
