/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/01/29
 */
package org.asyrinx.joey.gen.model.visitor;

import org.asyrinx.joey.gen.model.IVisitor;
import org.asyrinx.joey.gen.model.WmAppData;
import org.asyrinx.joey.gen.model.WmAspect;
import org.asyrinx.joey.gen.model.WmAspectAction;
import org.asyrinx.joey.gen.model.WmAspectRef;
import org.asyrinx.joey.gen.model.WmColumn;
import org.asyrinx.joey.gen.model.WmColumnFormat;
import org.asyrinx.joey.gen.model.WmDatabase;
import org.asyrinx.joey.gen.model.WmEnum;
import org.asyrinx.joey.gen.model.WmEnumEntry;
import org.asyrinx.joey.gen.model.WmForeignKey;
import org.asyrinx.joey.gen.model.WmIdMethodParameter;
import org.asyrinx.joey.gen.model.WmIndex;
import org.asyrinx.joey.gen.model.WmInheritance;
import org.asyrinx.joey.gen.model.WmJoin;
import org.asyrinx.joey.gen.model.WmProperty;
import org.asyrinx.joey.gen.model.WmTable;
import org.asyrinx.joey.gen.model.WmTableAspect;
import org.asyrinx.joey.gen.model.WmUnique;

/**
 * @author akima
 */
public abstract class CommonVisitor implements IVisitor {

	/**
	 * 
	 */
	public CommonVisitor() {
		super();
	}

	protected abstract void visitCommon(Object object);

	/**
	 * @see org.asyrinx.brownie.windmill.model.IVisitor#visit(org.asyrinx.brownie.windmill.model.WmAppData)
	 */
	public void visit(WmAppData appData) {
		visitCommon(appData);
	}

	/**
	 * @see org.asyrinx.brownie.windmill.model.IVisitor#visit(org.asyrinx.brownie.windmill.model.WmAspect)
	 */
	public void visit(WmAspect aspect) {
		visitCommon(aspect);
	}

	/**
	 * @see org.asyrinx.brownie.windmill.model.IVisitor#visit(org.asyrinx.brownie.windmill.model.WmAspectAction)
	 */
	public void visit(WmAspectAction aspectAction) {
		visitCommon(aspectAction);
	}

	/**
	 * @see org.asyrinx.brownie.windmill.model.IVisitor#visit(org.asyrinx.brownie.windmill.model.WmAspectRef)
	 */
	public void visit(WmAspectRef aspectRef) {
		visitCommon(aspectRef);
	}

	/**
	 * @see org.asyrinx.brownie.windmill.model.IVisitor#visit(org.asyrinx.brownie.windmill.model.WmColumn)
	 */
	public void visit(WmColumn column) {
		visitCommon(column);
	}

	/**
	 * @see org.asyrinx.brownie.windmill.model.IVisitor#visit(org.asyrinx.brownie.windmill.model.WmColumnFormat)
	 */
	public void visit(WmColumnFormat format) {
		visitCommon(format);
	}

	/**
	 * @see org.asyrinx.brownie.windmill.model.IVisitor#visit(org.asyrinx.brownie.windmill.model.WmDatabase)
	 */
	public void visit(WmDatabase database) {
		visitCommon(database);
	}

	/**
	 * @see org.asyrinx.brownie.windmill.model.IVisitor#visit(org.asyrinx.brownie.windmill.model.WmEnum)
	 */
	public void visit(WmEnum enum) {
		visitCommon(enum);
	}

	/**
	 * @see org.asyrinx.brownie.windmill.model.IVisitor#visit(org.asyrinx.brownie.windmill.model.WmEnumEntry)
	 */
	public void visit(WmEnumEntry enumEntry) {
		visitCommon(enumEntry);
	}

	/**
	 * @see org.asyrinx.brownie.windmill.model.IVisitor#visit(org.asyrinx.brownie.windmill.model.WmForeignKey)
	 */
	public void visit(WmForeignKey foreignKey) {
		visitCommon(foreignKey);
	}

	/**
	 * @see org.asyrinx.brownie.windmill.model.IVisitor#visit(org.asyrinx.brownie.windmill.model.WmIdMethodParameter)
	 */
	public void visit(WmIdMethodParameter idMethodParameter) {
		visitCommon(idMethodParameter);
	}

	/**
	 * @see org.asyrinx.brownie.windmill.model.IVisitor#visit(org.asyrinx.brownie.windmill.model.WmIndex)
	 */
	public void visit(WmIndex index) {
		visitCommon(index);
	}

	/**
	 * @see org.asyrinx.brownie.windmill.model.IVisitor#visit(org.asyrinx.brownie.windmill.model.WmInheritance)
	 */
	public void visit(WmInheritance inheritance) {
		visitCommon(inheritance);
	}

	/**
	 * @see org.asyrinx.brownie.windmill.model.IVisitor#visit(org.asyrinx.brownie.windmill.model.WmJoin)
	 */
	public void visit(WmJoin join) {
		visitCommon(join);
	}

	/**
	 * @see org.asyrinx.brownie.windmill.model.IVisitor#visit(org.asyrinx.brownie.windmill.model.WmProperty)
	 */
	public void visit(WmProperty property) {
		visitCommon(property);
	}

	/**
	 * @see org.asyrinx.brownie.windmill.model.IVisitor#visit(org.asyrinx.brownie.windmill.model.WmTable)
	 */
	public void visit(WmTable table) {
		visitCommon(table);
	}

	/**
	 * @see org.asyrinx.brownie.windmill.model.IVisitor#visit(org.asyrinx.brownie.windmill.model.WmTableAspect)
	 */
	public void visit(WmTableAspect tableAspect) {
		visitCommon(tableAspect);
	}

	/**
	 * @see org.asyrinx.brownie.windmill.model.IVisitor#visit(org.asyrinx.brownie.windmill.model.WmUnique)
	 */
	public void visit(WmUnique unique) {
		visitCommon(unique);
	}

}
