/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2003/12/31
 */
package org.asyrinx.joey.gen.task;

import java.io.IOException;
import java.util.Iterator;

import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.torque.engine.EngineException;
import org.apache.velocity.context.Context;
import org.asyrinx.joey.gen.model.TypeNameUtils;
import org.asyrinx.joey.gen.model.WmAppData;
import org.asyrinx.joey.gen.model.WmDatabase;
import org.asyrinx.joey.gen.model.WmTable;
import org.asyrinx.joey.gen.model.xml.AppDataBuilder;
import org.asyrinx.joey.gen.options.OmType;
import org.xml.sax.SAXException;

/**
 * @author akima
 */
public class JoeyDataModelTask extends BaseJoeyDataModelTask {

	/**
	 * 
	 */
	public JoeyDataModelTask() {
		super();
	}

	/**
	 * @see org.asyrinx.brownie.windmill.task.BaseDataModelTask#addNewAppData(java.lang.String)
	 */
	protected void addNewAppData(String fileName) throws EngineException {
		final AppDataBuilder builder =
			new AppDataBuilder(
				getTargetDatabase(),
				getTargetPackage(),
				getBasePathToDbProps());
		try {
			WmAppData ad = builder.execute(fileName);
			ad.setName(
				String.valueOf(
					getContextProperties().getProperty("torque.project")));
			combine(ad);
		} catch (IOException e) {
			throw new EngineException(e);
		} catch (SAXException e) {
			throw new EngineException(e);
		}
	}

	private void combine(WmAppData newAppData) {
		if (dataModels.isEmpty()) {
			dataModels.add(newAppData);
			return;
		}
		final WmAppData oldAppData = (WmAppData) dataModels.get(0);
		final Iterator dbIter = newAppData.getDbIterator();
		while (dbIter.hasNext()) {
			final WmDatabase newAppDataDb = (WmDatabase) dbIter.next();
			final WmDatabase oldDb = oldAppData.find(newAppDataDb.getName());
			if (oldDb == null) {
				oldAppData.addDatabase(newAppDataDb);
				continue;
			}
			final Iterator tableIter =
				IteratorUtils.arrayIterator(newAppDataDb.getTables());
			while (tableIter.hasNext()) {
				final WmTable newTable = (WmTable) tableIter.next();
				if (oldDb.getTable(newTable.getName()) == null)
					oldDb.addTable(newTable);
			}
		}
	}

	protected final PageGeneratingHelper pageGenerator =
		new PageGeneratingHelper();

	/**
	 * @see org.asyrinx.brownie.windmill.task.BaseDataModelTask#initControlContext()
	 */
	public Context initControlContext() throws Exception {
		final Context result = super.initControlContext();
		result.put("omTypeObj", OmType.findOmType(result.get("omType")));
		result.put("helper", new PageGeneratingHelper());
		result.put("stringUtils", new StringUtils());
		result.put("typeNameUtils", new TypeNameUtils());
		return result;
	}

}
