/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/02/08
 */
package org.asyrinx.joey.gen.task;

import org.apache.velocity.context.Context;

/**
 * @author akima
 */
public class JoeyDocumentationTask extends JoeyDataModelTask {

	/** output format for the generated docs */
	private String outputFormat;

	/**
	 * Get the current output format.
	 *
	 * @return the current output format
	 */
	public String getOutputFormat() {
		return outputFormat;
	}

	/**
	 * Set the current output format.
	 *
	 * @param v output format
	 */
	public void setOutputFormat(String v) {
		outputFormat = v;
	}

	/**
	 * Place our target package value into the context for use in the templates.
	 *
	 * @return the context
	 * @throws Exception a generic exception
	 */
	public Context initControlContext() throws Exception {
		super.initControlContext();
		context.put("outputFormat", outputFormat);
		context.put("escape", new org.apache.velocity.anakia.Escape());
		return context;
	}

}
