/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/01/29
 */
package test.org.asyrinx.brownie.windmill.model.xml;

import java.io.InputStream;

import junit.framework.TestCase;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.engine.database.model.TypeMap;
import org.asyrinx.brownie.core.io.sf.FileStreamFactory;
import org.asyrinx.brownie.core.io.sf.RelativeClassResourceStreamFactory;
import org.asyrinx.joey.gen.model.WmAppData;
import org.asyrinx.joey.gen.model.WmColumn;
import org.asyrinx.joey.gen.model.WmDatabase;
import org.asyrinx.joey.gen.model.WmForeignKey;
import org.asyrinx.joey.gen.model.WmProperty;
import org.asyrinx.joey.gen.model.WmTable;
import org.asyrinx.joey.gen.model.xml.AppDataBuilder;

/**
 * @author akima
 */
public class AppDataBuilderTest3 extends TestCase {

	/**
	 * Constructor for AppDataBuilderTest.
	 * @param name
	 */
	public AppDataBuilderTest3(String name) {
		super(name);
	}

	public static void main(String[] args) {
		junit.swingui.TestRunner.run(AppDataBuilderTest3.class);
	}

	Log log = LogFactory.getLog(this.getClass());

	/*
	 * Test for WmAppData execute(InputStream)
	 */
	public void testExecuteInputStream() {
		//BasicConfigurator.configure();

		TypeMap.initialize();

		final FileStreamFactory streamFactory =
			new RelativeClassResourceStreamFactory();
		try {
			final InputStream inputStream =
				streamFactory.newInput("JoeyTutorial-schema.xml");

			AppDataBuilder builder =
				new AppDataBuilder("postgresql", "test", "sql/base/");
			WmAppData appData = builder.execute(inputStream);
			//describe(appData);

			//<database name="chiffon" defaultIdMethod="idbroker">
			assertEquals(null, appData.getName());
			assertEquals(1, appData.getDatabases().length);
			final WmDatabase db = (WmDatabase) appData.getDatabase();
			//
			final WmTable tblCustomer = (WmTable) db.getTable("CUSTOMER");
			final WmTable tblProduct = (WmTable) db.getTable("PRODUCT");
			final WmTable tblOrders = (WmTable) db.getTable("ORDERS");

			final WmColumn customer_id =
				(WmColumn) tblCustomer.getColumn("CUSTOMER_ID");
			final WmColumn customer_name =
				(WmColumn) tblCustomer.getColumn("NAME");

			final WmColumn product_id =
				(WmColumn) tblProduct.getColumn("PRODUCT_ID");
			final WmColumn product_name =
				(WmColumn) tblProduct.getColumn("NAME");

			//			final WmColumn orders_id =
			//				(WmColumn) tblOrders.getColumn("orders_id");
			final WmColumn orders_customer_id =
				(WmColumn) tblOrders.getColumn("CUSTOMER_ID");
			final WmColumn orders_product_id =
				(WmColumn) tblOrders.getColumn("PRODUCT_ID");
			final WmProperty orders_customer_name =
				orders_customer_id.getAdditional();
			final WmProperty orders_product_name =
				orders_product_id.getAdditional();
			final WmForeignKey fkCustomer =
				(WmForeignKey) tblOrders.findForeignKey("fk_order_customer");
			final WmForeignKey fkProduct =
				(WmForeignKey) tblOrders.findForeignKey("fk_order_product");
			//
			assertEquals(
				customer_id,
				orders_customer_id.getForeignColumn(fkCustomer));
			assertEquals(
				customer_name,
				orders_customer_name.getForeignColumn(fkCustomer));
			assertEquals(
				product_id,
				orders_product_id.getForeignColumn(fkProduct));
			assertEquals(
				product_name,
				orders_product_name.getForeignColumn(fkProduct));

		} catch (Exception e) {
			e.printStackTrace();
			fail();
		}

	}

}
