/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.oid;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.Torque;
import org.apache.torque.TorqueException;
import org.apache.torque.map.DatabaseMap;
import org.apache.torque.map.TableMap;
import org.apache.torque.oid.IdGenerator;
import org.apache.torque.util.Transaction;

public class IDBroker
implements Runnable,
IdGenerator {
    public static final String ID_TABLE = "ID_TABLE";
    public static final String TABLE_NAME = "ID_TABLE.TABLE_NAME";
    public static final String NEXT_ID = "ID_TABLE.NEXT_ID";
    public static final String QUANTITY = "ID_TABLE.QUANTITY";
    private TableMap tableMap;
    private static final int DEFAULT_SIZE = 40;
    private Hashtable ids = new Hashtable(40);
    private Hashtable quantityStore = new Hashtable(40);
    private Hashtable lastQueryTime = new Hashtable(40);
    private static final int SLEEP_PERIOD = 60000;
    private static final float SAFETY_MARGIN = 1.2f;
    private Thread houseKeeperThread = null;
    private boolean transactionsSupported = false;
    private static final BigDecimal ONE = new BigDecimal("1");
    private Configuration configuration;
    private static final String DB_IDBROKER_CLEVERQUANTITY = "idbroker.clever.quantity";
    private static final String DB_IDBROKER_PREFETCH = "idbroker.prefetch";
    private static final String DB_IDBROKER_USENEWCONNECTION = "idbroker.usenewconnection";
    private Log log = LogFactory.getLog((Class)(class$org$apache$torque$oid$IDBroker == null ? (class$org$apache$torque$oid$IDBroker = IDBroker.class$("org.apache.torque.oid.IDBroker")) : class$org$apache$torque$oid$IDBroker));
    static /* synthetic */ Class class$org$apache$torque$oid$IDBroker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDBroker(TableMap tMap) {
        this.tableMap = tMap;
        this.configuration = Torque.getConfiguration();
        if (this.configuration.getBoolean(DB_IDBROKER_PREFETCH, true)) {
            this.houseKeeperThread = new Thread(this);
            this.houseKeeperThread.setDaemon(true);
            this.houseKeeperThread.start();
        }
        String dbName = tMap.getDatabaseMap().getName();
        Connection dbCon = null;
        try {
            dbCon = Torque.getConnection(dbName);
            this.transactionsSupported = dbCon.getMetaData().supportsTransactions();
        }
        catch (Exception e) {
            this.transactionsSupported = false;
        }
        finally {
            try {
                dbCon.close();
            }
            catch (Exception e) {}
        }
        if (!this.transactionsSupported) {
            this.log.warn((Object)("IDBroker is being used with db '" + dbName + "', which does not support transactions. IDBroker " + "attempts to use transactions to limit the possibility " + "of duplicate key generation.  Without transactions, " + "duplicate key generation is possible if multiple JVMs " + "are used or other means are used to write to the " + "database."));
        }
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public int getIdAsInt(Connection connection, Object tableName) throws Exception {
        return this.getIdAsBigDecimal(connection, tableName).intValue();
    }

    public long getIdAsLong(Connection connection, Object tableName) throws Exception {
        return this.getIdAsBigDecimal(connection, tableName).longValue();
    }

    public BigDecimal getIdAsBigDecimal(Connection connection, Object tableName) throws Exception {
        BigDecimal[] id = this.getNextIds((String)tableName, 1, connection);
        return id[0];
    }

    public String getIdAsString(Connection connection, Object tableName) throws Exception {
        return this.getIdAsBigDecimal(connection, tableName).toString();
    }

    public boolean isPriorToInsert() {
        return true;
    }

    public boolean isPostInsert() {
        return false;
    }

    public boolean isConnectionRequired() {
        return false;
    }

    public synchronized BigDecimal[] getNextIds(String tableName, int numOfIdsToReturn) throws Exception {
        return this.getNextIds(tableName, numOfIdsToReturn, null);
    }

    public synchronized BigDecimal[] getNextIds(String tableName, int numOfIdsToReturn, Connection connection) throws Exception {
        if (tableName == null) {
            throw new Exception("getNextIds(): tableName == null");
        }
        List availableIds = (List)this.ids.get(tableName);
        if (availableIds == null || availableIds.size() < numOfIdsToReturn) {
            if (availableIds == null) {
                this.log.debug((Object)"Forced id retrieval - no available list");
            } else {
                this.log.debug((Object)("Forced id retrieval - " + availableIds.size()));
            }
            this.storeIDs(tableName, true, connection);
            availableIds = (List)this.ids.get(tableName);
        }
        int size = availableIds.size() < numOfIdsToReturn ? availableIds.size() : numOfIdsToReturn;
        BigDecimal[] results = new BigDecimal[size];
        for (int i = size - 1; i >= 0; --i) {
            results[i] = (BigDecimal)availableIds.get(i);
            availableIds.remove(i);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String tableName) throws TorqueException, Exception {
        String query = new StringBuffer(100).append("select ").append(TABLE_NAME).append(" where ").append(TABLE_NAME).append("='").append(tableName).append('\'').toString();
        boolean exists = false;
        Connection dbCon = null;
        try {
            String databaseName = this.tableMap.getDatabaseMap().getName();
            dbCon = Torque.getConnection(databaseName);
            Statement statement = dbCon.createStatement();
            ResultSet rs = statement.executeQuery(query);
            exists = rs.next();
            statement.close();
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            try {
                dbCon.close();
            }
            catch (Exception e) {
                this.log.error((Object)"Release of connection failed.", (Throwable)e);
            }
            throw throwable;
        }
        try {
            dbCon.close();
        }
        catch (Exception e) {
            this.log.error((Object)"Release of connection failed.", (Throwable)e);
        }
        return exists;
    }

    public void run() {
        this.log.debug((Object)"IDBroker thread was started.");
        Thread thisThread = Thread.currentThread();
        while (this.houseKeeperThread == thisThread) {
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException exc) {
                // empty catch block
            }
            Iterator it = this.ids.keySet().iterator();
            while (it.hasNext()) {
                String tableName = (String)it.next();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("IDBroker thread checking for more keys on table: " + tableName));
                }
                List availableIds = (List)this.ids.get(tableName);
                int quantity = this.getQuantity(tableName, null).intValue();
                if (quantity <= availableIds.size()) continue;
                try {
                    this.storeIDs(tableName, false, null);
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug((Object)("Retrieved more ids for table: " + tableName));
                }
                catch (Exception exc) {
                    this.log.error((Object)("There was a problem getting new IDs for table: " + tableName), (Throwable)exc);
                }
            }
        }
        this.log.debug((Object)"IDBroker thread finished.");
    }

    public void stop() {
        this.houseKeeperThread = null;
    }

    private void checkTiming(String tableName) {
        if (!this.configuration.getBoolean(DB_IDBROKER_CLEVERQUANTITY, true) || !this.configuration.getBoolean(DB_IDBROKER_PREFETCH, true)) {
            return;
        }
        Date lastTime = (Date)this.lastQueryTime.get(tableName);
        Date now = new Date();
        if (lastTime != null) {
            long thenLong = lastTime.getTime();
            long nowLong = now.getTime();
            int timeLapse = (int)(nowLong - thenLong);
            if (timeLapse < 60000 && timeLapse > 0) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Unscheduled retrieval of more ids for table: " + tableName));
                }
                float rate = this.getQuantity(tableName, null).floatValue() / (float)timeLapse;
                this.quantityStore.put(tableName, new BigDecimal(Math.ceil(60000.0f * rate * 1.2f)));
            }
        }
        this.lastQueryTime.put(tableName, now);
    }

    private void storeIDs(String tableName, boolean adjustQuantity, Connection connection) throws Exception {
        BigDecimal nextId = null;
        BigDecimal quantity = null;
        DatabaseMap dbMap = this.tableMap.getDatabaseMap();
        if (adjustQuantity) {
            this.checkTiming(tableName);
        }
        boolean useNewConnection = connection == null || this.configuration.getBoolean(DB_IDBROKER_USENEWCONNECTION, true);
        try {
            if (useNewConnection) {
                connection = Transaction.beginOptional(dbMap.getName(), this.transactionsSupported);
            }
            quantity = this.getQuantity(tableName, connection);
            this.updateQuantity(connection, tableName, quantity);
            BigDecimal[] results = this.selectRow(connection, tableName);
            nextId = results[0];
            BigDecimal newNextId = nextId.add(quantity);
            this.updateNextId(connection, tableName, newNextId.toString());
            if (useNewConnection) {
                Transaction.commit(connection);
            }
        }
        catch (Exception e) {
            if (useNewConnection) {
                Transaction.rollback(connection);
            }
            throw e;
        }
        ArrayList<BigDecimal> availableIds = (ArrayList<BigDecimal>)this.ids.get(tableName);
        if (availableIds == null) {
            availableIds = new ArrayList<BigDecimal>();
            this.ids.put(tableName, availableIds);
        }
        int numId = quantity.intValue();
        for (int i = 0; i < numId; ++i) {
            availableIds.add(nextId);
            nextId = nextId.add(ONE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private BigDecimal getQuantity(String tableName, Connection connection) {
        BigDecimal quantity;
        block13: {
            Connection dbCon;
            quantity = null;
            if (!this.configuration.getBoolean(DB_IDBROKER_PREFETCH, true)) {
                quantity = new BigDecimal(1.0);
            } else if (this.quantityStore.containsKey(tableName)) {
                quantity = (BigDecimal)this.quantityStore.get(tableName);
            } else {
                dbCon = null;
                if (connection == null || this.configuration.getBoolean(DB_IDBROKER_USENEWCONNECTION, true)) {
                    String databaseName = this.tableMap.getDatabaseMap().getName();
                    dbCon = Torque.getConnection(databaseName);
                }
                BigDecimal[] results = this.selectRow(dbCon, tableName);
                quantity = results[1];
                this.quantityStore.put(tableName, quantity);
                Object var7_7 = null;
                try {
                    dbCon.close();
                }
                catch (Exception e2) {
                    this.log.error((Object)"Release of connection failed.", (Throwable)e2);
                }
            }
            break block13;
            {
                catch (Exception e) {
                    quantity = new BigDecimal(10.0);
                    Object var7_8 = null;
                    try {
                        dbCon.close();
                    }
                    catch (Exception e2) {
                        this.log.error((Object)"Release of connection failed.", (Throwable)e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                try {
                    dbCon.close();
                }
                catch (Exception e2) {
                    this.log.error((Object)"Release of connection failed.", (Throwable)e2);
                }
                throw throwable;
            }
        }
        return quantity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BigDecimal[] selectRow(Connection con, String tableName) throws Exception {
        BigDecimal[] results;
        block5: {
            StringBuffer stmt = new StringBuffer();
            stmt.append("SELECT ID_TABLE.NEXT_ID, ID_TABLE.QUANTITY").append(" FROM ID_TABLE").append(" WHERE TABLE_NAME = '").append(tableName).append('\'');
            Statement statement = null;
            results = new BigDecimal[2];
            try {
                statement = con.createStatement();
                ResultSet rs = statement.executeQuery(stmt.toString());
                if (rs.next()) {
                    results[0] = new BigDecimal(rs.getString(1));
                    results[1] = new BigDecimal(rs.getString(2));
                    break block5;
                }
                throw new TorqueException("The table " + tableName + " does not have a proper entry in the " + ID_TABLE);
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNextId(Connection con, String tableName, String id) throws Exception {
        StringBuffer stmt = new StringBuffer(id.length() + tableName.length() + 50);
        stmt.append("UPDATE ID_TABLE").append(" SET NEXT_ID = ").append(id).append(" WHERE TABLE_NAME = '").append(tableName).append('\'');
        Statement statement = null;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("updateNextId: " + stmt.toString()));
        }
        try {
            statement = con.createStatement();
            statement.executeUpdate(stmt.toString());
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateQuantity(Connection con, String tableName, BigDecimal quantity) throws Exception {
        StringBuffer stmt = new StringBuffer(quantity.toString().length() + tableName.length() + 50);
        stmt.append("UPDATE ID_TABLE").append(" SET QUANTITY = ").append(quantity).append(" WHERE TABLE_NAME = '").append(tableName).append('\'');
        Statement statement = null;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("updateQuantity: " + stmt.toString()));
        }
        try {
            statement = con.createStatement();
            statement.executeUpdate(stmt.toString());
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

