/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.gen.model;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.engine.database.model.Column;
import org.apache.torque.engine.database.model.Database;
import org.apache.torque.engine.database.model.ForeignKey;
import org.apache.torque.engine.database.model.Table;
import org.apache.torque.engine.database.model.TypeMap;
import org.asyrinx.joey.gen.model.FieldTypeImpl;
import org.asyrinx.joey.gen.model.IElement;
import org.asyrinx.joey.gen.model.IFieldType;
import org.asyrinx.joey.gen.model.IProperty;
import org.asyrinx.joey.gen.model.IVisitor;
import org.asyrinx.joey.gen.model.TypeNameUtils;
import org.asyrinx.joey.gen.model.WmColumnFormat;
import org.asyrinx.joey.gen.model.WmEnum;
import org.asyrinx.joey.gen.model.WmForeignKey;
import org.asyrinx.joey.gen.model.WmProperty;

public class WmColumn
extends Column
implements Cloneable,
IProperty,
IFieldType,
IElement {
    private final FieldTypeImpl fieldTypeImpl = new FieldTypeImpl(this);
    final Log log = LogFactory.getLog(this.getClass());
    private WmProperty additional = null;
    private String javaNamingMethod = null;
    private boolean inheritance = false;
    private boolean visible = true;
    private boolean readonly = false;
    private String label = null;
    private boolean isLoginName = false;
    private WmColumnFormat format = null;

    public WmColumn() {
    }

    public WmColumn(String name) {
        super(name);
    }

    public void accept(IVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return ObjectUtils.identityToString((Object)this);
    }

    public void finishLoad() {
        if (this.getJavaNamingMethod() == null) {
            this.setJavaNamingMethod(this.getTable().getDatabase().getDefaultJavaNamingMethod());
        }
        if (this.isPrimaryKey()) {
            this.setNotNull(true);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        WmColumn result = (WmColumn)super.clone();
        if (this.additional != null) {
            result.addProperty((WmProperty)this.additional.clone());
        }
        if (this.format != null) {
            result.setFormat((WmColumnFormat)this.format.clone());
        }
        return result;
    }

    public void addProperty(WmProperty property) {
        property.setColumn(this);
        this.additional = property;
    }

    public void setTable(Table parent) {
        super.setTable(parent);
    }

    public WmEnum getEnum() {
        return null;
    }

    public List getBelongForeignKeys() {
        ArrayList<ForeignKey> result = new ArrayList<ForeignKey>();
        Table localTable = this.getTable();
        Iterator fkIter = IteratorUtils.arrayIterator((Object[])localTable.getForeignKeys());
        while (fkIter.hasNext()) {
            ForeignKey fk = (ForeignKey)fkIter.next();
            Iterator localColNameIter = fk.getLocalColumns().iterator();
            while (localColNameIter.hasNext()) {
                String localColName = (String)localColNameIter.next();
                Column localCol = localTable.getColumn(localColName);
                if (localCol != this) continue;
                result.add(fk);
            }
        }
        return result;
    }

    public WmColumn getForeignColumn(WmForeignKey foreignKey) {
        Table localTable = this.getTable();
        Database database = localTable.getDatabase();
        Table foreignTable = database.getTable(foreignKey.getForeignTableName());
        Hashtable localForeignNameMap = foreignKey.getLocalForeignMapping();
        Iterator localColNameIter = foreignKey.getLocalColumns().iterator();
        while (localColNameIter.hasNext()) {
            String localColName = (String)localColNameIter.next();
            Column localCol = localTable.getColumn(localColName);
            String foreignColName = String.valueOf(localForeignNameMap.get(localColName));
            Column foreignCol = foreignTable.getColumn(foreignColName);
            if (localCol != this) continue;
            return (WmColumn)foreignCol;
        }
        return null;
    }

    public String getJavaClass() {
        return TypeNameUtils.toClassName(this.getJavaNativeType());
    }

    public String getJavaNativeType() {
        return TypeMap.getJavaNative((String)TypeMap.getJdbcType((String)String.valueOf(this.getTorqueType())));
    }

    public Object getType() {
        return super.getType();
    }

    public void setType(Object type) {
        super.setType(String.valueOf(type));
    }

    public String getDefaultValueString() {
        String value = this.getDefaultValue();
        if (StringUtils.isEmpty((String)value)) {
            return "";
        }
        if (StringUtils.equalsIgnoreCase((String)value, (String)"null")) {
            return "null";
        }
        String javaType = this.getJavaNativeType();
        if ("boolean".equals(javaType) || "Boolean".equals(javaType)) {
            if ("1".equals(value) || "Y".equalsIgnoreCase(value)) {
                value = "true";
            } else if ("0".equals(value) || "n".equalsIgnoreCase(value)) {
                value = "false";
            }
        }
        if ("String".equals(javaType)) {
            return "\"" + value + "\"";
        }
        if ("BigDecimal".equals(javaType)) {
            return "new BigDecimal(" + value + ")";
        }
        if ("NumberKey".equals(javaType)) {
            return "new NumberKey(\"" + value + "\")";
        }
        if ("StringKey".equals(javaType)) {
            return "new StringKey(\"" + value + "\")";
        }
        if (!this.isPrimitive()) {
            return "new " + javaType + "(" + value + ")";
        }
        return value;
    }

    public String getLabel() {
        if (StringUtils.isEmpty((String)this.label)) {
            return this.getName();
        }
        return this.label;
    }

    public boolean isLoginName() {
        return this.isLoginName;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setLoginName(boolean b) {
        this.isLoginName = b;
    }

    public void setReadonly(boolean b) {
        this.readonly = b;
    }

    public void setVisible(boolean b) {
        this.visible = b;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public WmProperty getAdditional() {
        return this.additional;
    }

    public void setAdditional(WmProperty property) {
        this.additional = property;
    }

    public boolean isRequired() {
        return this.isNotNull();
    }

    public void setRequired(boolean b) {
        this.setNotNull(b);
    }

    public WmColumnFormat getFormat() {
        return this.format;
    }

    public void setFormat(WmColumnFormat format) {
        this.format = format;
        format.setColumn(this);
    }

    public boolean isBooleanFieldType() {
        return this.fieldTypeImpl.isBooleanFieldType();
    }

    public boolean isDateFieldType() {
        return this.fieldTypeImpl.isDateFieldType();
    }

    public boolean isMemoFieldType() {
        return this.fieldTypeImpl.isMemoFieldType();
    }

    public boolean isNumberFieldType() {
        return this.fieldTypeImpl.isNumberFieldType();
    }

    public boolean isSelectFieldType() {
        return this.fieldTypeImpl.isSelectFieldType();
    }

    public boolean isTextFieldType() {
        return this.fieldTypeImpl.isTextFieldType();
    }

    public String getJavaNamingMethod() {
        return this.javaNamingMethod;
    }

    public void setJavaNamingMethod(String string) {
        this.javaNamingMethod = string;
    }

    public boolean isInheritance() {
        return this.inheritance;
    }

    public void setInheritance(boolean b) {
        this.inheritance = b;
    }
}

