/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.gen.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.asyrinx.joey.gen.model.IElement;
import org.asyrinx.joey.gen.model.IProperty;
import org.asyrinx.joey.gen.model.IVisitor;
import org.asyrinx.joey.gen.model.WmColumn;
import org.asyrinx.joey.gen.model.WmForeignKey;
import org.asyrinx.joey.gen.model.WmProperty;
import org.asyrinx.joey.gen.model.WmTable;

public class WmJoin
implements Cloneable,
IElement {
    private WmTable parentTable = null;
    private WmJoin parent = null;
    private List children = new ArrayList();
    public static final String TYPE_ONE_TO_ONE = "oneToOne";
    public static final String TYPE_ONE_TO_MANY = "oneToMany";
    private String type;
    private String table;
    private String foreignKey;

    public void accept(IVisitor visitor) {
        visitor.visit(this);
    }

    public Object clone() throws CloneNotSupportedException {
        WmJoin result = (WmJoin)super.clone();
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            WmJoin child = (WmJoin)iterator.next();
            result.addJoin((WmJoin)child.clone());
        }
        return result;
    }

    public void finishLoad() {
    }

    public void addJoin(WmJoin join) {
        join.setParent(this);
        this.children.add(join);
    }

    public WmTable getOwnerTable() {
        if (this.getParentTable() != null) {
            return this.getParentTable();
        }
        if (this.getParent() != null) {
            return this.getParent().getOwnerTable();
        }
        return null;
    }

    public WmTable getTargetTable() {
        return (WmTable)this.getOwnerTable().getDatabase().getTable(this.getTable());
    }

    public WmTable getLocalTable() {
        if (this.getParent() != null) {
            return this.getParent().getTargetTable();
        }
        return this.getParentTable();
    }

    /*
     * WARNING - void declaration
     */
    public WmForeignKey getTargetForeignKey() {
        void var1_1;
        WmTable fkOwner;
        if (TYPE_ONE_TO_ONE.equals(this.getType())) {
            fkOwner = this.getLocalTable();
        } else if (TYPE_ONE_TO_MANY.equals(this.getType())) {
            fkOwner = this.getTargetTable();
        } else {
            throw new RuntimeException("Illegal type: " + this.getType());
        }
        return var1_1.findForeignKey(this.getForeignKey());
    }

    public boolean needToShow(IProperty property) {
        List colList;
        WmForeignKey fk = this.getTargetForeignKey();
        if (TYPE_ONE_TO_ONE.equals(this.getType())) {
            colList = fk.getForeignColumns();
        } else if (TYPE_ONE_TO_MANY.equals(this.getType())) {
            colList = fk.getLocalColumns();
        } else {
            throw new RuntimeException("Illegal type: " + this.getType());
        }
        if (property instanceof WmColumn) {
            return !colList.contains(property.getName());
        }
        if (property instanceof WmProperty) {
            return !colList.contains(((WmProperty)property).getColumn().getName());
        }
        throw new RuntimeException("Illegal class: " + property.getName() + "(" + property.getClass().getName() + ")");
    }

    public String getBeanName() {
        WmForeignKey foreignKey = this.getTargetForeignKey();
        if (TYPE_ONE_TO_ONE.equals(this.getType())) {
            return foreignKey.getPropertyNameInLocal();
        }
        if (TYPE_ONE_TO_MANY.equals(this.getType())) {
            return foreignKey.getPropertyNameInReferred();
        }
        throw new RuntimeException("Illegal type: " + this.getType());
    }

    public String getBeanNameCapitalized() {
        return StringUtils.capitalize((String)this.getBeanName());
    }

    public String getChainedBeanName() {
        return this.getChainedBeanName(".");
    }

    public String getChainedBeanName(String separator) {
        if (this.getParent() != null) {
            return String.valueOf(this.getParent().getChainedBeanName(separator)) + separator + this.getBeanName();
        }
        return this.getBeanName();
    }

    public String getChainedBeanNameFromMany() {
        return this.getChainedBeanNameFromMany(".");
    }

    public String getChainedBeanNameFromMany(String separator) {
        if (TYPE_ONE_TO_MANY.equals(this.getType())) {
            return "";
        }
        if (this.getParent() != null) {
            if (TYPE_ONE_TO_ONE.equals(this.getParent().getType())) {
                return String.valueOf(this.getParent().getChainedBeanNameFromMany(separator)) + separator + this.getBeanName();
            }
            return this.getBeanName();
        }
        return this.getBeanName();
    }

    public WmJoin getAncestorOneToMany() {
        if (this.getParent() != null) {
            if (TYPE_ONE_TO_MANY.equals(this.getParent().getType())) {
                return this.getParent();
            }
            return this.getParent().getAncestorOneToMany();
        }
        return null;
    }

    public boolean isAncestorOfOneToMany() {
        Iterator iterator = this.getChildren().iterator();
        while (iterator.hasNext()) {
            WmJoin child = (WmJoin)iterator.next();
            if (TYPE_ONE_TO_MANY.equals(child.getType())) {
                return true;
            }
            if (!child.isAncestorOfOneToMany()) continue;
            return true;
        }
        return false;
    }

    public List getChildren() {
        return this.children;
    }

    public String getForeignKey() {
        return this.foreignKey;
    }

    public WmJoin getParent() {
        return this.parent;
    }

    public String getTable() {
        return this.table;
    }

    public void setChildren(List list) {
        this.children = list;
    }

    public void setForeignKey(String string) {
        this.foreignKey = string;
    }

    public void setParent(WmJoin join) {
        this.parent = join;
    }

    public void setTable(String string) {
        this.table = string;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public WmTable getParentTable() {
        return this.parentTable;
    }

    public void setParentTable(WmTable table) {
        this.parentTable = table;
    }
}

