/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.gen.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.engine.EngineException;
import org.apache.torque.engine.database.model.Column;
import org.apache.torque.engine.database.model.ForeignKey;
import org.apache.torque.engine.database.model.Index;
import org.apache.torque.engine.database.model.NameFactory;
import org.apache.torque.engine.database.model.Table;
import org.asyrinx.joey.gen.model.IElement;
import org.asyrinx.joey.gen.model.IFieldType;
import org.asyrinx.joey.gen.model.IProperty;
import org.asyrinx.joey.gen.model.IVisitor;
import org.asyrinx.joey.gen.model.WmAspect;
import org.asyrinx.joey.gen.model.WmAspectRef;
import org.asyrinx.joey.gen.model.WmColumn;
import org.asyrinx.joey.gen.model.WmDatabase;
import org.asyrinx.joey.gen.model.WmEnum;
import org.asyrinx.joey.gen.model.WmForeignKey;
import org.asyrinx.joey.gen.model.WmIndex;
import org.asyrinx.joey.gen.model.WmJoin;
import org.asyrinx.joey.gen.model.WmProperty;
import org.asyrinx.joey.gen.model.visitor.MockBaseVisitor;
import org.asyrinx.joey.gen.model.visitor.TopDownVisitor;

public class WmTable
extends Table
implements Cloneable,
IElement {
    final Log log = LogFactory.getLog(this.getClass());
    private String javaNamingMethod = null;
    private boolean heavyIndexing = false;
    private String displayPropertyName = null;
    private String loginNamePropertyName = null;
    private String label = null;
    private boolean isLoginUser = false;
    private final List aspectRefs = new ArrayList();
    private final List joins = new ArrayList();

    public WmTable() {
    }

    public WmTable(String name) {
        super(name);
    }

    public void accept(IVisitor visitor) {
        visitor.visit(this);
    }

    public void finishLoad() {
        if (StringUtils.isEmpty((String)this.getJavaNamingMethod())) {
            this.setJavaNamingMethod(this.getDatabase().getDefaultJavaNamingMethod());
        }
        if ("null".equals(this.getIdMethod())) {
            this.setIdMethod(this.getDatabase().getDefaultIdMethod());
        }
        if ("autoincrement".equals(this.getIdMethod()) || "sequence".equals(this.getIdMethod())) {
            this.log.warn((Object)("The value '" + this.getIdMethod() + "' for Torque's " + "table.idMethod attribute has been deprecated in favor " + "of '" + "native" + "'.  Please adjust your " + "Torque XML schema accordingly."));
            this.setIdMethod("native");
        }
        if (!this.isHeavyIndexing() && this.getDatabase().isHeavyIndexing()) {
            this.setHeavyIndexing(true);
        }
    }

    public void doFinalInitialization() {
        if (this.isHeavyIndexing()) {
            this.doHeavyIndexing();
        }
        this.doNaming();
    }

    protected final void doHeavyIndexing() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("doHeavyIndex() called on table " + this.getName()));
        }
        List pk = this.getPrimaryKey();
        int size = pk.size();
        try {
            int i = 1;
            while (i < size) {
                this.addIndex(new WmIndex(this, pk.subList(i, size)));
                ++i;
            }
        }
        catch (EngineException e) {
            this.log.error((Object)e, (Throwable)e);
        }
    }

    protected final void doNaming() {
        try {
            ForeignKey[] foreignKeies = this.getForeignKeys();
            int i = 0;
            int size = foreignKeies.length;
            while (i < size) {
                ForeignKey fk = foreignKeies[i];
                String name = fk.getName();
                if (StringUtils.isEmpty((String)name)) {
                    name = this.acquireConstraintName("FK", i + 1);
                    fk.setName(name);
                }
                ++i;
            }
            Index[] indexs = this.getIndices();
            int i2 = 0;
            int size2 = indexs.length;
            while (i2 < size2) {
                Index index = indexs[i2];
                String name = index.getName();
                if (StringUtils.isEmpty((String)name)) {
                    name = this.acquireConstraintName("I", i2 + 1);
                    index.setName(name);
                }
                ++i2;
            }
        }
        catch (EngineException nameAlreadyInUse) {
            this.log.error((Object)nameAlreadyInUse, (Throwable)nameAlreadyInUse);
        }
    }

    protected final String acquireConstraintName(String nameType, int nbr) throws EngineException {
        ArrayList<Object> inputs = new ArrayList<Object>(4);
        inputs.add(this.getDatabase());
        inputs.add(this.getName());
        inputs.add(nameType);
        inputs.add(new Integer(nbr));
        return NameFactory.generateName((String)NameFactory.CONSTRAINT_GENERATOR, inputs);
    }

    public String toString() {
        return ObjectUtils.identityToString((Object)this);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String getLabel() {
        if (StringUtils.isEmpty((String)this.label)) {
            return this.getName();
        }
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public void addColumn(Column col) {
        super.addColumn(col);
    }

    public void addAspectRef(WmAspectRef aspectRef) {
        aspectRef.setTable(this);
        this.aspectRefs.add(aspectRef);
    }

    public List getAspectRefs() {
        return this.aspectRefs;
    }

    public List getAspects() {
        ArrayList<WmAspect> result = new ArrayList<WmAspect>();
        Iterator iterator = this.aspectRefs.iterator();
        while (iterator.hasNext()) {
            WmAspectRef ref = (WmAspectRef)iterator.next();
            WmAspect aspect = ((WmDatabase)this.getDatabase()).findAspect(ref.getName());
            if (aspect == null) continue;
            result.add(aspect);
        }
        return result;
    }

    public List getProperties() {
        ArrayList<WmProperty> result = new ArrayList<WmProperty>();
        Iterator colIter = IteratorUtils.arrayIterator((Object[])this.getColumns());
        while (colIter.hasNext()) {
            WmColumn column = (WmColumn)colIter.next();
            if (column.getAdditional() == null) continue;
            result.add(column.getAdditional());
        }
        return result;
    }

    public List getAllProperties() {
        ArrayList<IFieldType> result = new ArrayList<IFieldType>();
        Iterator colIter = IteratorUtils.arrayIterator((Object[])this.getColumns());
        while (colIter.hasNext()) {
            WmColumn column = (WmColumn)colIter.next();
            result.add(column);
            if (column.getAdditional() == null) continue;
            result.add(column.getAdditional());
        }
        return result;
    }

    public IProperty findProperty(String name) {
        if (StringUtils.isEmpty((String)name)) {
            return null;
        }
        Iterator iterator = this.getProperties().iterator();
        while (iterator.hasNext()) {
            WmProperty property = (WmProperty)iterator.next();
            if (!name.equals(property.getName())) continue;
            return property;
        }
        Column column = this.getColumn(name);
        if (column instanceof IProperty) {
            return (IProperty)column;
        }
        return null;
    }

    public IProperty getDisplayProperty() {
        return this.findProperty(this.displayPropertyName);
    }

    public IProperty getLoginNameProperty() {
        return this.findProperty(this.loginNamePropertyName);
    }

    public void addJoin(WmJoin join) {
        join.setParentTable(this);
        this.joins.add(join);
    }

    public List getJoins() {
        return this.joins;
    }

    public List getPrimaryKeyNames() {
        List pkeys = this.getPrimaryKey();
        ArrayList<String> result = new ArrayList<String>(pkeys.size());
        Iterator iterator = pkeys.iterator();
        while (iterator.hasNext()) {
            Column col = (Column)iterator.next();
            result.add(col.getName());
        }
        return result;
    }

    public WmForeignKey findForeignKey(String name) {
        if (StringUtils.isEmpty((String)name)) {
            return null;
        }
        Iterator iterator = IteratorUtils.arrayIterator((Object[])this.getForeignKeys());
        while (iterator.hasNext()) {
            WmForeignKey foreignKey = (WmForeignKey)iterator.next();
            if (!name.equals(foreignKey.getName())) continue;
            return foreignKey;
        }
        return null;
    }

    public Set getJoinTableSet() {
        final HashSet result = new HashSet();
        TopDownVisitor visitor = new TopDownVisitor(new MockBaseVisitor(){

            public void visit(WmJoin join) {
                result.add(join.getTargetTable());
            }
        });
        this.accept(visitor);
        result.remove(this);
        return result;
    }

    public Set getEnums() {
        HashSet<WmEnum> result = new HashSet<WmEnum>();
        Iterator iter = this.getProperties().iterator();
        while (iter.hasNext()) {
            WmProperty prop = (WmProperty)iter.next();
            if (prop.getEnum() == null) continue;
            result.add(prop.getEnum());
        }
        return result;
    }

    public boolean isLoginUser() {
        return this.isLoginUser;
    }

    public void setLoginUser(boolean b) {
        this.isLoginUser = b;
    }

    public String getDisplayPropertyName() {
        return this.displayPropertyName;
    }

    public void setDisplayPropertyName(String string) {
        this.displayPropertyName = string;
    }

    public String getLoginNamePropertyName() {
        return this.loginNamePropertyName;
    }

    public void setLoginNamePropertyName(String string) {
        this.loginNamePropertyName = string;
    }

    public String getJavaNamingMethod() {
        return this.javaNamingMethod;
    }

    public void setJavaNamingMethod(String string) {
        this.javaNamingMethod = string;
    }

    public boolean isHeavyIndexing() {
        return this.heavyIndexing;
    }

    public void setHeavyIndexing(boolean b) {
        this.heavyIndexing = b;
    }
}

