/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.gen.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.lang.exception.NestableRuntimeException;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.asyrinx.joey.gen.model.IVisitor;
import org.asyrinx.joey.gen.model.WmAspectRef;
import org.asyrinx.joey.gen.model.WmColumn;
import org.asyrinx.joey.gen.model.WmForeignKey;
import org.asyrinx.joey.gen.model.WmIndex;
import org.asyrinx.joey.gen.model.WmJoin;
import org.asyrinx.joey.gen.model.WmTable;
import org.asyrinx.joey.gen.model.WmUnique;

public class WmTableAspect
extends WmTable {
    private final List includeTableNamePatterns = new ArrayList();
    private final List excludeTableNamePatterns = new ArrayList();

    public WmTableAspect() {
    }

    public WmTableAspect(String name) {
        super(name);
    }

    public void accept(IVisitor visitor) {
        visitor.visit(this);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void addInclude(String tableNamePattern) {
        this.includeTableNamePatterns.add(tableNamePattern);
    }

    public void addExclude(String tableNamePattern) {
        this.excludeTableNamePatterns.add(tableNamePattern);
    }

    private boolean matches(Iterator patternIterator, String tableName) {
        while (patternIterator.hasNext()) {
            String patternStr = (String)patternIterator.next();
            if ("*".equals(patternStr)) {
                return true;
            }
            try {
                RE re = new RE(patternStr);
                boolean result = re.match(tableName);
                if (!result) continue;
                return true;
            }
            catch (RESyntaxException e) {
                throw new NestableRuntimeException("Syntax Error:" + patternStr, (Throwable)e);
            }
        }
        return false;
    }

    private boolean isIncluded(String tableName) {
        return this.matches(this.includeTableNamePatterns.iterator(), tableName);
    }

    private boolean isExcluded(String tableName) {
        return this.matches(this.excludeTableNamePatterns.iterator(), tableName);
    }

    private boolean isTarget(WmTable table) {
        String tableName = table.getName();
        if (this.isIncluded(tableName)) {
            return !this.isExcluded(tableName);
        }
        return false;
    }

    public void apply() {
        Iterator iterator = IteratorUtils.arrayIterator((Object[])this.getDatabase().getTables());
        while (iterator.hasNext()) {
            WmTable table = (WmTable)iterator.next();
            if (!this.isTarget(table)) continue;
            this.copy(table);
        }
    }

    public void copy(WmTable dest) {
        try {
            Iterator colIter = IteratorUtils.arrayIterator((Object[])this.getColumns());
            while (colIter.hasNext()) {
                WmColumn col = (WmColumn)colIter.next();
                dest.addColumn((WmColumn)col.clone());
            }
            Iterator indexIter = IteratorUtils.arrayIterator((Object[])this.getIndices());
            while (indexIter.hasNext()) {
                WmIndex index = (WmIndex)indexIter.next();
                dest.addIndex((WmIndex)index.clone());
            }
            Iterator fkIter = IteratorUtils.arrayIterator((Object[])this.getForeignKeys());
            while (fkIter.hasNext()) {
                WmForeignKey fk = (WmForeignKey)fkIter.next();
                dest.addForeignKey((WmForeignKey)fk.clone());
            }
            Iterator uniqIter = IteratorUtils.arrayIterator((Object[])this.getUnices());
            while (uniqIter.hasNext()) {
                WmUnique unique = (WmUnique)uniqIter.next();
                dest.addUnique((WmUnique)unique.clone());
            }
            Iterator arefIter = this.getAspectRefs().iterator();
            while (arefIter.hasNext()) {
                WmAspectRef aspectRef = (WmAspectRef)arefIter.next();
                dest.addAspectRef((WmAspectRef)aspectRef.clone());
            }
            Iterator joinIter = this.getJoins().iterator();
            while (joinIter.hasNext()) {
                WmJoin join = (WmJoin)joinIter.next();
                dest.addJoin((WmJoin)join.clone());
            }
        }
        catch (CloneNotSupportedException e) {
            throw new NestableRuntimeException((Throwable)e);
        }
    }
}

