/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.gen.task;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.lang.exception.NestableRuntimeException;
import org.apache.torque.engine.EngineException;
import org.apache.torque.engine.database.model.Database;
import org.apache.torque.engine.database.model.NameFactory;
import org.asyrinx.brownie.core.io.StreamUtils;
import org.asyrinx.brownie.core.io.sf.StreamFactoryFacade;
import org.asyrinx.brownie.core.lang.StringUtils;
import org.asyrinx.joey.gen.model.WmAppData;
import org.asyrinx.joey.gen.model.WmJoin;
import org.asyrinx.joey.gen.model.WmTable;

public class PageGeneratingHelper {
    private Map stackMap = new HashMap();

    public String toJavaName(String value) {
        return this.toJavaNameUnderScore(value);
    }

    public String toJavaName(String value, String javaNamingMethod) {
        ArrayList<String> inputs = new ArrayList<String>(2);
        inputs.add(value);
        inputs.add(javaNamingMethod);
        try {
            return NameFactory.generateName((String)NameFactory.JAVA_GENERATOR, inputs);
        }
        catch (EngineException e) {
            throw new NestableRuntimeException((Throwable)e);
        }
    }

    public String toJavaNameUnderScore(String value) {
        return this.toJavaName(value, "underscore");
    }

    public String toJavaNameJavaName(String value) {
        return this.toJavaName(value, "javaname");
    }

    public String toJavaNameNoChange(String value) {
        return this.toJavaName(value, "nochange");
    }

    public boolean match(String value, String options) {
        List optionList = StringUtils.tokenize((String)options, (String)",");
        return optionList.indexOf(value) > -1;
    }

    public List getAllTables(List appDataList) {
        ArrayList result = new ArrayList();
        Iterator appIter = appDataList.iterator();
        while (appIter.hasNext()) {
            WmAppData appData = (WmAppData)appIter.next();
            Iterator dbIter = appData.getDbIterator();
            while (dbIter.hasNext()) {
                Database db = (Database)dbIter.next();
                Iterator tableIter = IteratorUtils.arrayIterator((Object[])db.getTables());
                while (tableIter.hasNext()) {
                    result.add(tableIter.next());
                }
            }
        }
        return result;
    }

    public WmTable findUserTable(List tableList) {
        Iterator iterator = tableList.iterator();
        while (iterator.hasNext()) {
            WmTable table = (WmTable)iterator.next();
            if (!table.isLoginUser()) continue;
            return table;
        }
        return null;
    }

    public boolean containJoin(List joins, String type) {
        Iterator iterator = joins.iterator();
        while (iterator.hasNext()) {
            WmJoin join = (WmJoin)iterator.next();
            if (!org.apache.commons.lang.StringUtils.equals((String)join.getType(), (String)type)) continue;
            return true;
        }
        return false;
    }

    public boolean containOneToOneJoin(List joins) {
        return this.containJoin(joins, "oneToOne");
    }

    public boolean containOneToManyJoin(List joins) {
        return this.containJoin(joins, "oneToMany");
    }

    public Stack getStack(String name) {
        Stack result = (Stack)this.stackMap.get(name);
        if (result == null) {
            result = new Stack();
            this.stackMap.put(name, result);
        }
        return result;
    }

    public void clearStack(String stackName) {
        Stack stack = this.getStack(stackName);
        stack.clear();
    }

    public void push(String stackName, Object value) {
        Stack stack = this.getStack(stackName);
        stack.push(value);
    }

    public Object pop(String stackName) {
        Stack stack = this.getStack(stackName);
        return stack.pop();
    }

    public Object newInstance(String className) {
        try {
            return Class.forName(className).newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void copyFile(String sourceFilename, String destFilename) throws IOException {
        File source = new File(sourceFilename);
        if (!source.exists()) {
            throw new FileNotFoundException(sourceFilename);
        }
        FileInputStream inputStream = new FileInputStream(source);
        FileOutputStream outputStream = new FileOutputStream(destFilename);
        StreamUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        inputStream.close();
        outputStream.close();
    }

    public void copyResourceToFile(String sourceResourcePath, String destFilename) throws IOException {
        int len;
        StreamFactoryFacade sf = StreamFactoryFacade.newFacade();
        InputStream inputStream = sf.newInput((Object)sourceResourcePath);
        FileOutputStream outputStream = new FileOutputStream(destFilename);
        byte[] buf = new byte[256];
        while ((len = inputStream.read(buf)) != -1) {
            outputStream.write(buf, 0, len);
        }
        outputStream.flush();
        outputStream.close();
        inputStream.close();
    }
}

