/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.util;

import java.util.Calendar;
import java.util.Date;
import org.asyrinx.brownie.core.util.DateUtils;

public final class SimpleDate {
    private final int year;
    private final int month;
    private final int day;

    public SimpleDate(int year, int month, int day) {
        this.year = year;
        this.month = month;
        this.day = day;
    }

    public SimpleDate(Date d) {
        this(d, Calendar.getInstance());
    }

    public SimpleDate(Date d, Calendar calendar) {
        calendar.setTime(d);
        this.year = calendar.get(1);
        this.month = calendar.get(2);
        this.day = calendar.get(5);
    }

    public Date toDate() {
        return this.toDateBegin();
    }

    public Date toDateBegin() {
        return DateUtils.toDateBegin(this.year, this.month, this.day);
    }

    public Date toDateEnd() {
        return DateUtils.toDateEnd(this.year, this.month, this.day);
    }

    public boolean equals(Object obj) {
        if (obj instanceof SimpleDate) {
            SimpleDate date = (SimpleDate)obj;
            return this.year == date.year && this.month == date.month && this.day == date.day;
        }
        if (obj instanceof Date) {
            return this.equals(new SimpleDate((Date)obj));
        }
        return super.equals(obj);
    }

    public boolean after(SimpleDate when) {
        if (when.year < this.year) {
            return true;
        }
        if (when.year > this.year) {
            return false;
        }
        if (when.month < this.month) {
            return true;
        }
        if (when.month > this.month) {
            return false;
        }
        return when.day < this.day;
    }

    public boolean before(SimpleDate when) {
        if (when.year > this.year) {
            return true;
        }
        if (when.year < this.year) {
            return false;
        }
        if (when.month > this.month) {
            return true;
        }
        if (when.month < this.month) {
            return false;
        }
        return when.day > this.day;
    }

    public String toString() {
        return String.valueOf(this.year) + "/" + this.month + "/" + this.day;
    }

    public int getDay() {
        return this.day;
    }

    public int getMonth() {
        return this.month;
    }

    public int getYear() {
        return this.year;
    }
}

