/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.jdbc.logger;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.asyrinx.brownie.core.log.CascadeNamedLog;
import org.asyrinx.brownie.jdbc.logger.LogCallableStatement;
import org.asyrinx.brownie.jdbc.logger.LogPreparedStatement;
import org.asyrinx.brownie.jdbc.logger.LogStatement;
import org.asyrinx.brownie.jdbc.wrapper.ConnectionWrapper;

public class LogConnection
extends ConnectionWrapper {
    private final CascadeNamedLog log;

    public LogConnection(Connection wrapped, CascadeNamedLog parentLog) {
        super(wrapped);
        this.log = parentLog.subLog(this.wrapped);
    }

    public Statement createStatement() throws SQLException {
        return new LogStatement(super.createStatement(), this.log);
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new LogStatement(super.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability), this.log);
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return new LogStatement(super.createStatement(resultSetType, resultSetConcurrency), this.log);
    }

    public String nativeSQL(String sql) throws SQLException {
        try {
            String result = super.nativeSQL(sql);
            this.log.log(sql);
            return result;
        }
        catch (SQLException e) {
            this.log.log((Object)sql, e);
            throw e;
        }
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new LogCallableStatement(super.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability), sql, this.log);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new LogCallableStatement(super.prepareCall(sql, resultSetType, resultSetConcurrency), sql, this.log);
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        return new LogCallableStatement(super.prepareCall(sql), sql, this.log);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new LogPreparedStatement(super.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability), sql, this.log);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new LogPreparedStatement(super.prepareStatement(sql, resultSetType, resultSetConcurrency), sql, this.log);
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return new LogPreparedStatement(super.prepareStatement(sql, autoGeneratedKeys), sql, this.log);
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return new LogPreparedStatement(super.prepareStatement(sql, columnIndexes), sql, this.log);
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return new LogPreparedStatement(super.prepareStatement(sql, columnNames), sql, this.log);
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return new LogPreparedStatement(super.prepareStatement(sql), sql, this.log);
    }
}

