/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.tapestry.components.layer;

import java.util.Map;
import org.apache.tapestry.IAsset;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.asyrinx.brownie.tapestry.components.layer.BaseDesktopComponent;

public abstract class Popup
extends BaseDesktopComponent {
    private int frame = 10;
    private int interval = 20;
    private int cellSpacing = 0;
    private int cellPadding = 0;
    private int border = 0;
    private IAsset popdownImage = null;

    public Popup() {
        super("Popup.script");
        this.setWidth("300");
        this.setHeight(null);
    }

    protected void finishLoad() {
        this.setPopdownImage(this.getAsset("img_popdown"));
    }

    public void prepareScriptSymbols(Map symbols, IRequestCycle cycle) {
        super.prepareScriptSymbols(symbols, cycle);
        symbols.put("link_id", this.getLinkId());
        symbols.put("frame", new Integer(this.getFrame()));
        symbols.put("interval", new Integer(this.getInterval()));
    }

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        this.checkBeforeRender(writer, cycle);
        this.scriptWriter.execute(cycle);
        writer.begin("div");
        writer.attribute("id", this.getStyleId());
        writer.attribute("style", "VISIBILITY:hidden; " + this.toStyleValue());
        this.renderInformalParameters(writer, cycle);
        writer.println();
        super.renderComponent(writer, cycle);
        writer.end();
    }

    public String getInvokePopdown() {
        return "popdown_btn_" + this.getStyleId() + "_click()";
    }

    public abstract String getLinkId();

    public abstract void setLinkId(String var1);

    public int getFrame() {
        return this.frame;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setFrame(int i) {
        this.frame = i;
    }

    public void setInterval(int i) {
        this.interval = i;
    }

    public int getBorder() {
        return this.border;
    }

    public int getCellPadding() {
        return this.cellPadding;
    }

    public int getCellSpacing() {
        return this.cellSpacing;
    }

    public IAsset getPopdownImage() {
        return this.popdownImage;
    }

    public void setBorder(int i) {
        this.border = i;
    }

    public void setCellPadding(int i) {
        this.cellPadding = i;
    }

    public void setCellSpacing(int i) {
        this.cellSpacing = i;
    }

    public void setPopdownImage(IAsset asset) {
        this.popdownImage = asset;
    }
}

