/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/02/25
 */
package org.asyrinx.joey.test.dao;

import java.io.File;
import java.io.FileNotFoundException;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.NestableRuntimeException;
import org.asyrinx.brownie.core.io.FileNameUtils;

/**
 * @author akima
 */
public class WebAppDaoTestConfigImpl implements WebAppDaoTestConfig {

	public WebAppDaoTestConfigImpl() {
		super();
	}
	//private String dbName;
	private String contextPath;
	private String ormType;
	private String appContextFilename;

	void initialize() {
		if (StringUtils.isEmpty(appContextFilename))
			appContextFilename = "applicationContext-" + ormType + ".xml";
		appContextFilename = getRealPath(appContextFilename);
	}

	public String getRealPath(String filename) {
		String f = filename;
		if (exists(f))
			return new File(f).getAbsolutePath();
		filename = FileNameUtils.deleteSeparatorHead(filename);
		final String[] pathes =
			new String[] { "/", "/WEB-INF/", "/WEB-INF/conf/", };
		for (int i = 0; i < pathes.length; i++) {
			f =
				FileNameUtils.toFileSeparator(
					FileNameUtils.toAbsolutePath(
						contextPath + pathes[i],
						filename));
			if (exists(f))
				return f;
			System.out.println("file not found: " + f);
		}
		throw new NestableRuntimeException(new FileNotFoundException(filename));
	}

	private boolean exists(String filename) {
		return new File(filename).exists();
	}

	/**
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		final StringBuffer result = new StringBuffer("test config: \n");
		result.append("ormType=").append(getOrmType()).append("\n");
		result.append("contextPath=").append(getContextPath()).append("\n");
		result
			.append("applicationCOntextFilename=")
			.append(getAppContextFilename())
			.append("\n");
		return result.toString();
	}

	/**
	 * @return
	 */
	public String getContextPath() {
		return contextPath;
	}

	/**
	 * @param string
	 */
	public void setContextPath(String string) {
		contextPath = string;
	}

	/**
	 * @return
	 */
	public String getOrmType() {
		return ormType;
	}

	/**
	 * @param string
	 */
	public void setOrmType(String string) {
		ormType = string;
	}

	/**
	 * @return
	 */
	public String getAppContextFilename() {
		return appContextFilename;
	}

	/**
	 * @param string
	 */
	public void setAppContextFilename(String string) {
		appContextFilename = string;
	}

}
