/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/02/25
 */
package org.asyrinx.joey.test.dao;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;

/**
 * @author akima
 */
public class WebAppDaoTestContext extends AbstractXmlApplicationContext {

	/**
	 * @param parent
	 */
	public WebAppDaoTestContext(
		WebAppDaoTestConfig config,
		String configLocation) {
		this(config, new String[] { configLocation });
	}

	/**
	 * @param parent
	 */
	public WebAppDaoTestContext(
		WebAppDaoTestConfig config,
		String[] configLocations) {
		this(config, configLocations, null);
	}

	/**
	 * @param parent
	 */
	public WebAppDaoTestContext(
		WebAppDaoTestConfig config,
		String[] configLocations,
		ApplicationContext parent) {
		super(parent);
		this.configLocations = configLocations;
		this.config = config;
	}

	/**
	 * @see org.springframework.context.support.AbstractApplicationContext#refresh()
	 */
	public void refresh() throws BeansException {
		//loadLibraries();
		super.refresh();
	}

	/*
	protected void loadLibraries() {
		final File libDir = new File(config.getRealPath("/WEB-INF/lib"));
		if (!libDir.exists() || !libDir.isDirectory())
			return;
		final File[] jars = libDir.listFiles(new FilenameFilter() {
			public boolean accept(File dir, String name) {
				return name.endsWith(".jar");
			}
		});
		final URL[] urls = new URL[jars.length];
		for (int i = 0; i < urls.length; i++) {
			try {
				urls[i] = jars[i].toURL();
				System.out.println("loadLibraries: " + urls[i]);
			} catch (MalformedURLException e) {
				throw new NestableRuntimeException(e);
			}
		}
	
		Thread.currentThread().setContextClassLoader(
			URLClassLoader.newInstance(
				urls,
				Thread.currentThread().getContextClassLoader()));
	
	}
	*/

	private final WebAppDaoTestConfig config;
	private final String[] configLocations;

	/**
	 * @see org.springframework.context.support.AbstractXmlApplicationContext#loadBeanDefinitions(org.springframework.beans.factory.xml.XmlBeanDefinitionReader)
	 */
	protected void loadBeanDefinitions(XmlBeanDefinitionReader reader)
		throws BeansException, IOException {
		if (this.configLocations != null) {
			for (int i = 0; i < this.configLocations.length; i++) {
				reader.loadBeanDefinitions(
					getResource(this.configLocations[i]));
			}
		}
	}

	/**
	 * @see org.springframework.context.support.AbstractApplicationContext#getResourceByPath(java.lang.String)
	 */
	protected Resource getResourceByPath(String path) {
		return new WebAppDaoTestResource(config, path);
	}

	/**
	 * @return
	 */
	public WebAppDaoTestConfig getConfig() {
		return config;
	}

}
class WebAppDaoTestResource extends AbstractResource {

	/**
	 * 
	 */
	public WebAppDaoTestResource(WebAppDaoTestConfig config, String path) {
		super();
		this.config = config;
		this.path = path;
	}

	private final WebAppDaoTestConfig config;
	private final String path;

	/**
	 * This implementation delegates to ServletContext.getResourceAsStream,
	 * but throws a FileNotFoundException if not found.
	 * @see javax.servlet.ServletContext#getResourceAsStream
	 */
	public InputStream getInputStream() throws IOException {
		final File file = getFile();
		if (file == null)
			throw new FileNotFoundException(
				"Could not open " + getDescription());
		return new FileInputStream(file);
	}

	/**
	 * This implementation delegates to ServletContext.getRealPath,
	 * but throws a FileNotFoundException if not found or not resolvable.
	 * @see javax.servlet.ServletContext#getRealPath
	 */
	public File getFile() throws IOException {
		String realPath = this.config.getRealPath(this.path);
		if (realPath != null) {
			return new File(realPath);
		} else {
			throw new FileNotFoundException(
				getDescription()
					+ " cannot be resolved to absolute file path - "
					+ "web application archive not expanded?");
		}
	}

	public String getDescription() {
		return "resource [" + this.path + "] of WebAppDaoTestContext";
	}

}
