/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/02/25
 */
package org.asyrinx.joey.test.dao;

import java.io.IOException;

import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.asyrinx.brownie.core.io.FileNameUtils;
import org.asyrinx.brownie.core.lang.ArrayUtils;
import org.asyrinx.brownie.core.lang.StringUtils;

/**
 * @author akima
 */
public class WebAppDaoTestContextBuilder {

	private final Log log = LogFactory.getLog(this.getClass());

	public WebAppDaoTestContext getContext(String[] args) throws IOException {
		log.info(
			"args ={"
				+ StringUtils.connectString(ArrayUtils.toArrayList(args), " ")
				+ "}");

		final WebAppDaoTestConfig config = getTestConfig(args);
		final WebAppDaoTestContext result =
			new WebAppDaoTestContext(config, config.getAppContextFilename());
		result.refresh();
		return result;
	}

	public WebAppDaoTestConfig getTestConfig(String[] args)
		throws IOException {
		final WebAppDaoTestConfigImpl result = new WebAppDaoTestConfigImpl();
		//
		final Options options = initOptions();
		final CommandLineParser parser = new BasicParser();
		final CommandLine cl;
		try {
			cl = parser.parse(options, args);
			if (cl.hasOption("help")) {
				final HelpFormatter formatter = new HelpFormatter();
				formatter.printHelp("", options);
				return null;
			}
		} catch (ParseException e) {
			e.printStackTrace();
			return null;
		}
		result.setContextPath(
			FileNameUtils.deleteSeparatorTail(cl.getOptionValue("c")));
		result.setOrmType(cl.getOptionValue("o"));
		result.setAppContextFilename(cl.getOptionValue("ac"));
		result.initialize();
		return result;
	}

	private Options initOptions() {
		final Options options = new Options();
		options.addOption("h", "help", false, "pring help messages");
		options.addOption(
			newRequired("c", "context", true, "web context path"));
		options.addOption(
			newRequired(
				"o",
				"orm",
				true,
				"O/R mapping type (hibernate, jdbc ...)"));
		options.addOption("ac", "file", true, "application context file name");
		options.addOption(
			"td",
			"testdata",
			true,
			"test dataset filename for testing by dbunit");
		return options;
	}

	private static Option newRequired(
		String shortName,
		String name,
		boolean hasArg,
		String description) {
		final Option result = new Option(shortName, name, hasArg, description);
		result.setRequired(true);
		return result;
	}

}
