/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.test.dao;

import java.io.File;
import java.io.FileNotFoundException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.NestableRuntimeException;
import org.asyrinx.brownie.core.io.FileNameUtils;
import org.asyrinx.joey.test.dao.WebAppDaoTestConfig;

public class WebAppDaoTestConfigImpl
implements WebAppDaoTestConfig {
    private String contextPath;
    private String ormType;
    private String appContextFilename;

    void initialize() {
        if (StringUtils.isEmpty((String)this.appContextFilename)) {
            this.appContextFilename = "applicationContext-" + this.ormType + ".xml";
        }
        this.appContextFilename = this.getRealPath(this.appContextFilename);
    }

    public String getRealPath(String filename) {
        String f = filename;
        if (this.exists(f)) {
            return new File(f).getAbsolutePath();
        }
        filename = FileNameUtils.deleteSeparatorHead((String)filename);
        String[] pathes = new String[]{"/", "/WEB-INF/", "/WEB-INF/conf/"};
        int i = 0;
        while (i < pathes.length) {
            f = FileNameUtils.toFileSeparator((String)FileNameUtils.toAbsolutePath((String)(String.valueOf(this.contextPath) + pathes[i]), (String)filename));
            if (this.exists(f)) {
                return f;
            }
            System.out.println("file not found: " + f);
            ++i;
        }
        throw new NestableRuntimeException((Throwable)new FileNotFoundException(filename));
    }

    private boolean exists(String filename) {
        return new File(filename).exists();
    }

    public String toString() {
        StringBuffer result = new StringBuffer("test config: \n");
        result.append("ormType=").append(this.getOrmType()).append("\n");
        result.append("contextPath=").append(this.getContextPath()).append("\n");
        result.append("applicationCOntextFilename=").append(this.getAppContextFilename()).append("\n");
        return result.toString();
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String string) {
        this.contextPath = string;
    }

    public String getOrmType() {
        return this.ormType;
    }

    public void setOrmType(String string) {
        this.ormType = string;
    }

    public String getAppContextFilename() {
        return this.appContextFilename;
    }

    public void setAppContextFilename(String string) {
        this.appContextFilename = string;
    }
}

