/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.test.dao;

import java.io.IOException;
import java.util.Collection;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.asyrinx.brownie.core.io.FileNameUtils;
import org.asyrinx.brownie.core.lang.ArrayUtils;
import org.asyrinx.brownie.core.lang.StringUtils;
import org.asyrinx.joey.test.dao.WebAppDaoTestConfig;
import org.asyrinx.joey.test.dao.WebAppDaoTestConfigImpl;
import org.asyrinx.joey.test.dao.WebAppDaoTestContext;

public class WebAppDaoTestContextBuilder {
    private final Log log = LogFactory.getLog(this.getClass());

    public WebAppDaoTestContext getContext(String[] args) throws IOException {
        this.log.info((Object)("args ={" + StringUtils.connectString((Collection)ArrayUtils.toArrayList((Object[])args), (String)" ") + "}"));
        WebAppDaoTestConfig config = this.getTestConfig(args);
        WebAppDaoTestContext result = new WebAppDaoTestContext(config, config.getAppContextFilename());
        result.refresh();
        return result;
    }

    public WebAppDaoTestConfig getTestConfig(String[] args) throws IOException {
        CommandLine cl;
        WebAppDaoTestConfigImpl result = new WebAppDaoTestConfigImpl();
        Options options = this.initOptions();
        BasicParser parser = new BasicParser();
        try {
            cl = parser.parse(options, args);
            if (cl.hasOption("help")) {
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp("", options);
                return null;
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
        result.setContextPath(FileNameUtils.deleteSeparatorTail((String)cl.getOptionValue("c")));
        result.setOrmType(cl.getOptionValue("o"));
        result.setAppContextFilename(cl.getOptionValue("ac"));
        result.initialize();
        return result;
    }

    private Options initOptions() {
        Options options = new Options();
        options.addOption("h", "help", false, "pring help messages");
        options.addOption(WebAppDaoTestContextBuilder.newRequired("c", "context", true, "web context path"));
        options.addOption(WebAppDaoTestContextBuilder.newRequired("o", "orm", true, "O/R mapping type (hibernate, jdbc ...)"));
        options.addOption("ac", "file", true, "application context file name");
        options.addOption("td", "testdata", true, "test dataset filename for testing by dbunit");
        return options;
    }

    private static Option newRequired(String shortName, String name, boolean hasArg, String description) {
        Option result = new Option(shortName, name, hasArg, description);
        result.setRequired(true);
        return result;
    }
}

