<?php
/**
* @version $Id: mod_fullmenu.php 158 2005-09-18 02:53:14Z stingrey $
* @package Joomla
* @copyright Copyright (C) 2005 Open Source Matters. All rights reserved.
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
* Joomla! is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* See COPYRIGHT.php for copyright notices and details.
*/

// no direct access
defined( '_VALID_MOS' ) or die( 'Restricted access' );

/**
* Full DHTML Admnistrator Menus
* @package Joomla
*/
class mosFullAdminMenu {
	/**
	* Show the menu
	* @param string The current user type
	*/
	function show( $usertype='' ) {
		global $acl, $database;
		global $mosConfig_live_site, $mosConfig_enable_stats, $mosConfig_caching;

		// cache some acl checks
		$canConfig 			= $acl->acl_check( 'administration', 'config', 'users', $usertype );

		$manageTemplates 	= $acl->acl_check( 'administration', 'manage', 'users', $usertype, 'components', 'com_templates' );
		$manageTrash 		= $acl->acl_check( 'administration', 'manage', 'users', $usertype, 'components', 'com_trash' );
		$manageMenuMan 		= $acl->acl_check( 'administration', 'manage', 'users', $usertype, 'components', 'com_menumanager' );
		$manageLanguages 	= $acl->acl_check( 'administration', 'manage', 'users', $usertype, 'components', 'com_languages' );
		$installModules 	= $acl->acl_check( 'administration', 'install', 'users', $usertype, 'modules', 'all' );
		$editAllModules 	= $acl->acl_check( 'administration', 'edit', 'users', $usertype, 'modules', 'all' );
		$installMambots 	= $acl->acl_check( 'administration', 'install', 'users', $usertype, 'mambots', 'all' );
		$editAllMambots 	= $acl->acl_check( 'administration', 'edit', 'users', $usertype, 'mambots', 'all' );
		$installComponents 	= $acl->acl_check( 'administration', 'install', 'users', $usertype, 'components', 'all' );
		$editAllComponents 	= $acl->acl_check( 'administration', 'edit', 'users', $usertype, 'components', 'all' );
		$canMassMail 		= $acl->acl_check( 'administration', 'manage', 'users', $usertype, 'components', 'com_massmail' );
		$canManageUsers 	= $acl->acl_check( 'administration', 'manage', 'users', $usertype, 'components', 'com_users' );

		$query = "SELECT a.id, a.title, a.name, COUNT( DISTINCT c.id ) AS numcat, COUNT( DISTINCT b.id ) AS numarc"
		. "\n FROM #__sections AS a"
		. "\n LEFT JOIN #__categories AS c ON c.section = a.id"
		. "\n LEFT JOIN #__content AS b ON b.sectionid = a.id AND b.state = -1"
		. "\n WHERE a.scope = 'content'"
		. "\n GROUP BY a.id"
		. "\n ORDER BY a.ordering"
		;
		$database->setQuery( $query );
		$sections = $database->loadObjectList();
		$nonemptySections = 0;
		foreach ($sections as $section)
			if ($section->numcat > 0)
				$nonemptySections++;
		$menuTypes = mosAdminMenus::menutypes();
		?>
		<div id="myMenuID"></div>
		<script language="JavaScript" type="text/javascript">
		var myMenu =
		[
		<?php
	// Home Sub-Menu
?>			[null,'Home','index2.php',null,'Control Panel'],
			_cmSplit,
			<?php
	// Site Sub-Menu
?>			[null,'サイト',null,null,'Site Management',
<?php
			if ($canConfig) {
?>				['<img src="../includes/js/ThemeOffice/config.png" />','グローバル・コンフィグレーション','index2.php?option=com_config&hidemainmenu=1',null,'サイト設定'],
<?php
			}
			if ($manageLanguages) {
?>				['<img src="../includes/js/ThemeOffice/language.png" />','ランゲージ管理',null,null,'ランゲージ管理',
  					['<img src="../includes/js/ThemeOffice/language.png" />','サイトランゲージ','index2.php?option=com_languages',null,'ランゲージ管理'],
   				],
<?php
			}
?>				['<img src="../includes/js/ThemeOffice/media.png" />','メディアマネージャ','index2.php?option=com_media',null,'メディアファイル管理'],
					['<img src="../includes/js/ThemeOffice/preview.png" />', 'プレビュー', null, null, 'プレビュー',
					['<img src="../includes/js/ThemeOffice/preview.png" />','新規Window','<?php echo $mosConfig_live_site; ?>/index.php','_blank','<?php echo $mosConfig_live_site; ?>'],
					['<img src="../includes/js/ThemeOffice/preview.png" />','インライン','index2.php?option=com_admin&task=preview',null,'<?php echo $mosConfig_live_site; ?>'],
					['<img src="../includes/js/ThemeOffice/preview.png" />','インラインポジション','index2.php?option=com_admin&task=preview2',null,'<?php echo $mosConfig_live_site; ?>'],
				],
				['<img src="../includes/js/ThemeOffice/globe1.png" />', '統計', null, null, 'サイトステータス',
<?php
			if ($mosConfig_enable_stats == 1) {
?>					['<img src="../includes/js/ThemeOffice/globe4.png" />', 'ブラウザ, OS, ドメイン', 'index2.php?option=com_statistics', null, 'ブラウザ, OS, ドメイン'],
  					['<img src="../includes/js/ThemeOffice/globe3.png" />', 'ページ・インプレッション', 'index2.php?option=com_statistics&task=pageimp', null, 'ページ・インプレッション'],
<?php
			}
?>					['<img src="../includes/js/ThemeOffice/search_text.png" />', '検索キーワード', 'index2.php?option=com_statistics&task=searches', null, '検索キーワード']
				],
<?php
			if ($manageTemplates) {
?>				['<img src="../includes/js/ThemeOffice/template.png" />','テンプレート管理',null,null,'サイトテンプレート変更',
  					['<img src="../includes/js/ThemeOffice/template.png" />','サイトテンプレート','index2.php?option=com_templates',null,'サイトテンプレート変更'],
  					_cmSplit,
  					['<img src="../includes/js/ThemeOffice/template.png" />','アドミンテンプレート','index2.php?option=com_templates&client=admin',null,'アドミンテンプレート'],
  					_cmSplit,
  					['<img src="../includes/js/ThemeOffice/template.png" />','モジュール ポジション','index2.php?option=com_templates&task=positions',null,'テンプレート表示位置']
  				],
<?php
			}
			if ($manageTrash) {
?>				['<img src="../includes/js/ThemeOffice/trash.png" />','ゴミ箱','index2.php?option=com_trash',null,'ゴミ箱'],
<?php
			}
			if ($canManageUsers || $canMassMail) {
?>				['<img src="../includes/js/ThemeOffice/users.png" />','ユーザ管理','index2.php?option=com_users&task=view',null,'ユーザ管理'],
<?php
				}
?>			],
<?php
	// Menu Sub-Menu
?>			_cmSplit,
			[null,'メニュー',null,null,'メニュー管理',
<?php
			if ($manageMenuMan) {
?>				['<img src="../includes/js/ThemeOffice/menus.png" />','メニュー管理','index2.php?option=com_menumanager',null,'メニュー管理'],
				_cmSplit,
<?php
			}
			foreach ( $menuTypes as $menuType ) {
?>				['<img src="../includes/js/ThemeOffice/menus.png" />','<?php echo $menuType;?>','index2.php?option=com_menus&menutype=<?php echo $menuType;?>',null,''],
<?php
			}
?>			],
			_cmSplit,
<?php
	// Content Sub-Menu
?>			[null,'コンテンツ',null,null,'コンテンツ管理',
<?php
			if (count($sections) > 0) {
?>				['<img src="../includes/js/ThemeOffice/edit.png" />','セクションコンテンツ',null,null,'セクションコンテンツ',
<?php
				foreach ($sections as $section) {
					$txt = addslashes( $section->title ? $section->title : $section->name );
?>					['<img src="../includes/js/ThemeOffice/document.png" />','<?php echo $txt;?>', null, null,'<?php echo $txt;?>',
<?php
					if ($section->numcat) {
?>						['<img src="../includes/js/ThemeOffice/edit.png" />', '<?php echo $txt;?> アイテム', 'index2.php?option=com_content&sectionid=<?php echo $section->id;?>',null,null],
<?php
					}
?>						['<img src="../includes/js/ThemeOffice/add_section.png" />', '<?php echo $txt;?>カテゴリ 編集/追加', 'index2.php?option=com_categories&section=<?php echo $section->id;?>',null, null],
<?php
					if ($section->numarc) {
?>						['<img src="../includes/js/ThemeOffice/backup.png" />', '<?php echo $txt;?> アーカイブ', 'index2.php?option=com_content&task=showarchive&sectionid=<?php echo $section->id;?>',null,null],
<?php
					}
?>					],
<?php
				} // foreach
?>				],
				_cmSplit,
<?php
			}
?>
				['<img src="../includes/js/ThemeOffice/edit.png" />','全てのコンテンツ','index2.php?option=com_content&sectionid=0',null,'コンテンツアイテム管理'],
  				['<img src="../includes/js/ThemeOffice/edit.png" />','静的コンテンツ管理','index2.php?option=com_typedcontent',null,'静的コンテンツ管理'],
  				_cmSplit,
  				['<img src="../includes/js/ThemeOffice/add_section.png" />','セクション管理','index2.php?option=com_sections&scope=content',null,'コンテンツセクション管理'],
				['<img src="../includes/js/ThemeOffice/add_section.png" />','カテゴリー管理','index2.php?option=com_categories&section=content',null,'コンテンツカテゴリー管理'],
				_cmSplit,
  				['<img src="../includes/js/ThemeOffice/home.png" />','フロントページ管理','index2.php?option=com_frontpage',null,'フロントページ管理'],
  				['<img src="../includes/js/ThemeOffice/edit.png" />','アーカイブ管理','index2.php?option=com_content&task=showarchive&sectionid=0',null,'アーカイブ管理'],
			],
<?php
	// Components Sub-Menu
	if ($installComponents) {
?>			_cmSplit,
			[null,'コンポーネント',null,null,'コンポーネント管理',
<?php
		$query = "SELECT *"
		. "\n FROM #__components"
		. "\n WHERE name <> 'frontpage'"
		. "\n AND name <> 'media manager'"
		. "\n ORDER BY ordering, name"
		;
		$database->setQuery( $query );
		$comps = $database->loadObjectList();	// component list
		$subs = array();	// sub menus
		// first pass to collect sub-menu items
		foreach ($comps as $row) {
			if ($row->parent) {
				if (!array_key_exists( $row->parent, $subs )) {
					$subs[$row->parent] = array();
				}
				$subs[$row->parent][] = $row;
			}
		}
		$topLevelLimit = 19; //You can get 19 top levels on a 800x600 Resolution
		$topLevelCount = 0;
		foreach ($comps as $row) {
			if ($editAllComponents | $acl->acl_check( 'administration', 'edit', 'users', $usertype, 'components', $row->option )) {
				if ($row->parent == 0 && (trim( $row->admin_menu_link ) || array_key_exists( $row->id, $subs ))) {
					$topLevelCount++;
					if ($topLevelCount > $topLevelLimit) {
						continue;
					}
					$name = addslashes( $row->name );
					$alt = addslashes( $row->admin_menu_alt );
					$link = $row->admin_menu_link ? "'index2.php?$row->admin_menu_link'" : "null";
					echo "\t\t\t\t['<img src=\"../includes/$row->admin_menu_img\" />','$name',$link,null,'$alt'";
					if (array_key_exists( $row->id, $subs )) {
						foreach ($subs[$row->id] as $sub) {
							echo ",\n";
							$name = addslashes( $sub->name );
							$alt = addslashes( $sub->admin_menu_alt );
							$link = $sub->admin_menu_link ? "'index2.php?$sub->admin_menu_link'" : "null";
							echo "\t\t\t\t\t['<img src=\"../includes/$sub->admin_menu_img\" />','$name',$link,null,'$alt']";
						}
					}
					echo "\n\t\t\t\t],\n";
				}
			}
		}
		if ($topLevelLimit < $topLevelCount) {
			echo "\t\t\t\t['<img src=\"../includes/js/ThemeOffice/sections.png\" />','さらに多くのコンポーネント...','index2.php?option=com_admin&task=listcomponents',null,'More Components'],\n";
		}
?>
			],
<?php
	// Modules Sub-Menu
		if ($installModules | $editAllModules) {
?>			_cmSplit,
			[null,'モジュール',null,null,'モジュール管理',
<?php
			if ($editAllModules) {
?>				['<img src="../includes/js/ThemeOffice/module.png" />', 'サイトモジュール', "index2.php?option=com_modules", null, 'サイトモジュール'],
				['<img src="../includes/js/ThemeOffice/module.png" />', 'アドミンモジュール', "index2.php?option=com_modules&client=admin", null, 'アドミンモジュール管理'],
<?php
			}
?>			],
<?php
		} // if ($installModules | $editAllModules)
	} // if $installComponents
	// Mambots Sub-Menu
	if ($installMambots | $editAllMambots) {
?>			_cmSplit,
			[null,'マンボット',null,null,'マンボット管理',
<?php
		if ($editAllMambots) {
?>				['<img src="../includes/js/ThemeOffice/module.png" />', 'サイトマンボット', "index2.php?option=com_mambots", null, 'サイトマンボット管理'],
<?php
		}
?>			],
<?php
	}
?>
<?php
	// Installer Sub-Menu
	if ($installModules) {
?>			_cmSplit,
			[null,'インストーラ',null,null,'インストーラリスト',
<?php
		if ($manageTemplates) {
?>				['<img src="../includes/js/ThemeOffice/install.png" />','サイト - テンプレート','index2.php?option=com_installer&element=template&client=',null,'サイトテンプレートインストール'],
				['<img src="../includes/js/ThemeOffice/install.png" />','アドミン - テンプレート','index2.php?option=com_installer&element=template&client=admin',null,'アドミンテンプレートインストール'],
<?php
		}
		if ($manageLanguages) {
?>				['<img src="../includes/js/ThemeOffice/install.png" />','ランゲージ','index2.php?option=com_installer&element=language',null,'ランゲージインストール'],
				_cmSplit,
<?php
		}
?>				['<img src="../includes/js/ThemeOffice/install.png" />', 'コンポーネント','index2.php?option=com_installer&element=component',null,'コンポーネント インストール/アンインストール'],
				['<img src="../includes/js/ThemeOffice/install.png" />', 'モジュール', 'index2.php?option=com_installer&element=module', null, 'モジュール インストール/アンインストール'],
				['<img src="../includes/js/ThemeOffice/install.png" />', 'マンボット', 'index2.php?option=com_installer&element=mambot', null, 'マンボット インストール/アンインストール'],
			],
<?php
	} // if ($installModules)
	// Messages Sub-Menu
	if ($canConfig) {
?>			_cmSplit,
  			[null,'メッセージ',null,null,'メッセージ管理',
  				['<img src="../includes/js/ThemeOffice/messaging_inbox.png" />','受信トレイ','index2.php?option=com_messages',null,'プラーベートメッセージ'],
  				['<img src="../includes/js/ThemeOffice/messaging_config.png" />','設定','index2.php?option=com_messages&task=config&hidemainmenu=1',null,'設定']
  			],
<?php
	// System Sub-Menu
?>			_cmSplit,
  			[null,'システム',null,null,'システム管理',
  			   ['<img src="../includes/js/ThemeOffice/sysinfo.png" />', 'システム情報', 'index2.php?option=com_admin&task=sysinfo', null,'システム情報'],

<?php
  		if ($canConfig) {
?>				['<img src="../includes/js/ThemeOffice/checkin.png" />', 'グローバル・チェックイン', 'index2.php?option=com_checkin', null,'グローバル・チェックイン'],
<?php
			if ($mosConfig_caching) {
?>				['<img src="../includes/js/ThemeOffice/config.png" />','コンテンツキャッシュ削除','index2.php?option=com_admin&task=clean_cache',null,'コンテンツアイテムキャッシュ削除'],
				['<img src="../includes/js/ThemeOffice/config.png" />','キャッシュ削除','index2.php?option=com_admin&task=clean_all_cache',null,'キャッシュ削除'],
<?php
			}
		}
?>			],
<?php
			}
?>			_cmSplit,
<?php
	// Help Sub-Menu
?>			[null,'Help','index2.php?option=com_admin&task=help',null,null]
		];
		cmDraw ('myMenuID', myMenu, 'hbr', cmThemeOffice, 'ThemeOffice');
		</script>
<?php
	}


	/**
	* Show an disbaled version of the menu, used in edit pages
	* @param string The current user type
	*/
	function showDisabled( $usertype='' ) {
		global $acl, $_LANG;

		$canConfig 			= $acl->acl_check( 'administration', 'config', 'users', $usertype );
		$installModules 	= $acl->acl_check( 'administration', 'install', 'users', $usertype, 'modules', 'all' );
		$editAllModules 	= $acl->acl_check( 'administration', 'edit', 'users', $usertype, 'modules', 'all' );
		$installMambots 	= $acl->acl_check( 'administration', 'install', 'users', $usertype, 'mambots', 'all' );
		$editAllMambots 	= $acl->acl_check( 'administration', 'edit', 'users', $usertype, 'mambots', 'all' );
		$installComponents 	= $acl->acl_check( 'administration', 'install', 'users', $usertype, 'components', 'all' );
		$editAllComponents 	= $acl->acl_check( 'administration', 'edit', 'users', $usertype, 'components', 'all' );
		$canMassMail 		= $acl->acl_check( 'administration', 'manage', 'users', $usertype, 'components', 'com_massmail' );
		$canManageUsers 	= $acl->acl_check( 'administration', 'manage', 'users', $usertype, 'components', 'com_users' );

		$text = 'Menu inactive for this Page';
		?>
		<div id="myMenuID" class="inactive"></div>
		<script language="JavaScript" type="text/javascript">
		var myMenu =
		[
		<?php
	/* Home Sub-Menu */
		?>
			[null,'<?php echo 'Home'; ?>',null,null,'<?php echo $text; ?>'],
			_cmSplit,
		<?php
	/* Site Sub-Menu */
		?>
			[null,'<?php echo 'サイト'; ?>',null,null,'<?php echo $text; ?>'
			],
		<?php
	/* Menu Sub-Menu */
		?>
			_cmSplit,
			[null,'<?php echo 'メニュー'; ?>',null,null,'<?php echo $text; ?>'
			],
			_cmSplit,
		<?php
	/* Content Sub-Menu */
		?>
 			[null,'<?php echo 'コンテンツ'; ?>',null,null,'<?php echo $text; ?>'
			],
		<?php
	/* Components Sub-Menu */
			if ( $installComponents) {
				?>
				_cmSplit,
				[null,'<?php echo 'コンポーネント'; ?>',null,null,'<?php echo $text; ?>'
				],
				<?php
			} // if $installComponents
			?>
		<?php
	/* Modules Sub-Menu */
			if ( $installModules | $editAllModules) {
				?>
				_cmSplit,
				[null,'<?php echo 'モジュール'; ?>',null,null,'<?php echo $text; ?>'
				],
				<?php
			} // if ( $installModules | $editAllModules)
			?>
		<?php
	/* Mambots Sub-Menu */
			if ( $installMambots | $editAllMambots) {
				?>
				_cmSplit,
				[null,'<?php echo 'マンボット'; ?>',null,null,'<?php echo $text; ?>'
				],
				<?php
			} // if ( $installMambots | $editAllMambots)
			?>


			<?php
	/* Installer Sub-Menu */
			if ( $installModules) {
				?>
				_cmSplit,
				[null,'<?php echo 'インストーラ'; ?>',null,null,'<?php echo $text; ?>'
					<?php
					?>
				],
				<?php
			} // if ( $installModules)
			?>
			<?php
	/* Messages Sub-Menu */
			if ( $canConfig) {
				?>
				_cmSplit,
	  			[null,'<?php echo 'メッセージ'; ?>',null,null,'<?php echo $text; ?>'
	  			],
				<?php
			}
			?>

			<?php
	/* System Sub-Menu */
			if ( $canConfig) {
				?>
				_cmSplit,
	  			[null,'<?php echo 'システム'; ?>',null,null,'<?php echo $text; ?>'
				],
				<?php
			}
			?>
			_cmSplit,
			<?php
	/* Help Sub-Menu */
			?>
			[null,'<?php echo 'Help'; ?>',null,null,'<?php echo $text; ?>']
		];
		cmDraw ('myMenuID', myMenu, 'hbr', cmThemeOffice, 'ThemeOffice');
		</script>
		<?php
	}
}
$cache =& mosCache::getCache( 'mos_fullmenu' );

$hide = mosGetParam( $_REQUEST, 'hidemainmenu', 0 );

if ( $hide ) {
	mosFullAdminMenu::showDisabled( $my->usertype );
} else {
	mosFullAdminMenu::show( $my->usertype );
}
?>