<?php
/**
* @version $Id: index.php 85 2005-09-15 23:12:03Z eddieajau $
* @package Joomla
* @copyright Copyright (C) 2005 Open Source Matters. All rights reserved.
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
* Joomla! is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* See COPYRIGHT.php for copyright notices and details.
*/

if (file_exists( '../configuration.php' ) && filesize( '../configuration.php' ) > 10) {
	header( "Location: ../index.php" );
	exit();
}
require_once( '../includes/version.php' );

/** Include common.php */
include_once( "common.php" );

function get_php_setting($val) {
	$r =  (ini_get($val) == '1' ? 1 : 0);
	return $r ? 'ON' : 'OFF';
}

function writableCell( $folder ) {
	echo '<tr>';
	echo '<td class="item">' . $folder . '/</td>';
	echo '<td align="left">';
	echo is_writable( "../$folder" ) ? '<b><font color="green">書込み可</font></b>' : '<b><font color="red">書込み不可</font></b>' . '</td>';
	echo '</tr>';
}

echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?".">";
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title>Joomla - Web インストーラ</title>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<link rel="shortcut icon" href="../../images/favicon.ico" />
<link rel="stylesheet" href="install.css" type="text/css" />
</head>
<body>

<div id="wrapper">
<div id="header">
<div id="joomla"><img src="header_install.png" alt="Joomla インストール" /></div>
</div>
</div>

<div id="ctr" align="center">
<div class="install">
<div id="stepbar">
<div class="step-on">設置前チェック</div>
<div class="step-off">ライセンス</div>
<div class="step-off">ステップ 1</div>
<div class="step-off">ステップ 2</div>
<div class="step-off">ステップ 3</div>
<div class="step-off">ステップ 4</div>
</div>

<div id="right">

<div id="step">設置前チェック</div>

<div class="far-right">
	<input name="Button2" type="submit" class="button" value="次へ >>" onclick="window.location='install.php';" />
	<br/>
	<br/>
	<input type="button" class="button" value="もう一度チェック" onclick="window.location=window.location" />
</div>
<div class="clr"></div>

<h1>設置前チェック:<br/><?php echo $version; ?></h1>
<div class="install-text">
これらのアイテムが赤く強調されているなら
修正して下さい。 修正しないとJoomlaのインストールに
失敗する場合
があります。
<div class="ctr"></div>
</div>

<div class="install-form">
<div class="form-block">

<table class="content">
<tr>
	<td class="item">
	PHP version >= 4.1.0
	</td>
	<td align="left">
	<?php echo phpversion() < '4.1' ? '<b><font color="red">No</font></b>' : '<b><font color="green">Yes</font></b>';?>
	</td>
</tr>
<tr>
	<td>
	&nbsp; - zlib compression support
	</td>
	<td align="left">
	<?php echo extension_loaded('zlib') ? '<b><font color="green">有効</font></b>' : '<b><font color="red">無効</font></b>';?>
	</td>
</tr>
<tr>
	<td>
	&nbsp; - XML support
	</td>
	<td align="left">
	<?php echo extension_loaded('xml') ? '<b><font color="green">有効</font></b>' : '<b><font color="red">無効</font></b>';?>
	</td>
</tr>
<tr>
	<td>
	&nbsp; - MySQL support
	</td>
	<td align="left">
	<?php echo function_exists( 'mysql_connect' ) ? '<b><font color="green">有効</font></b>' : '<b><font color="red">無効</font></b>';?>
	</td>
</tr>
<tr>
	<td>
	&nbsp; - マルチバイト サポート
	</td>
	<td align="left">
	<?php echo function_exists( 'mb_convert_encoding' ) ? '<b><font color="green">有効</font></b>' : '<b><font color="red">無効</font></b>';?>
	</td>
</tr>
<tr>
	<td valign="top" class="item">
	configuration.php
	</td>
	<td align="left">
	<?php
	if (@file_exists('../configuration.php') &&  @is_writable( '../configuration.php' )){
		echo '<b><font color="green">書込み可</font></b>';
	} else if (is_writable( '..' )) {
		echo '<b><font color="green">書込み可</font></b>';
	} else {
		echo '<b><font color="red">書込み不可</font></b><br /><span class="small">インストール終了後に表示される設定ファイルをコピーしてアップロードするならインストールを継続できます。</span>';
    } ?>
	</td>
</tr>
<tr>
	<td class="item">
	Session save path
	</td>
	<td align="left">
	<b><?php echo (($sp=ini_get('session.save_path'))?$sp:'Not set'); ?></b>,
	<?php echo is_writable( $sp ) ? '<b><font color="green">書込み可</font></b>' : '<b><font color="red">書込み不可</font></b>';?>
	</td>
</tr>
</table>
</div>
</div>
<div class="clr"></div>

<h1>お勧め設定:</h1>
<div class="install-text">
Joomla!を正常に作動させる為にこれらの設定が
推薦されています。
<br />
しかし完全に同じではなくてもJoomla!は作動するかもしれません
<div class="ctr"></div>
</div>

<div class="install-form">
<div class="form-block">

<table class="content">
<tr>
	<td class="toggle">
	ディレクティブ
	</td>
	<td class="toggle">
	お勧め
	</td>
	<td class="toggle">
	現在
	</td>
</tr>
<?php
$php_recommended_settings = array(array ('Safe Mode','safe_mode','OFF'),
array ('Display Errors','display_errors','ON'),
array ('File Uploads','file_uploads','ON'),
array ('Magic Quotes GPC','magic_quotes_gpc','ON'),
array ('Magic Quotes Runtime','magic_quotes_runtime','OFF'),
array ('Register Globals','register_globals','OFF'),
array ('Output Buffering','output_buffering','OFF'),
array ('Session auto start','session.auto_start','OFF'),
);

foreach ($php_recommended_settings as $phprec) {
?>
<tr>
	<td class="item"><?php echo $phprec[0]; ?>:</td>
	<td class="toggle"><?php echo $phprec[2]; ?>:</td>
	<td>
	<?php
	if ( get_php_setting($phprec[1]) == $phprec[2] ) {
	?>
		<font color="green"><b>
	<?php
	} else {
	?>
		<font color="red"><b>
	<?php
	}
	echo get_php_setting($phprec[1]);
	?>
	</b></font>
	<td>
</tr>
<?php
}
?>
</table>
</div>
</div>
<div class="clr"></div>

<h1>ディレクトリとファイルパーミッション:</h1>
<div class="install-text">
Joomlaが正常に作動するようにするには
ディレクトリとファイルぱミッションの設定が必要です。
もし"書込み不可" になっているなら該当するディレクトリに
書込み権限を設定して下さい。
<div class="clr">&nbsp;&nbsp;</div>
<div class="ctr"></div>
</div>

<div class="install-form">
<div class="form-block">

<table class="content">
<?php
writableCell( 'administrator/backups' );
writableCell( 'administrator/components' );
writableCell( 'administrator/modules' );
writableCell( 'administrator/templates' );
writableCell( 'cache' );
writableCell( 'components' );
writableCell( 'images' );
writableCell( 'images/banners' );
writableCell( 'images/stories' );
writableCell( 'language' );
writableCell( 'mambots' );
writableCell( 'mambots/content' );
writableCell( 'mambots/search' );
writableCell( 'media' );
writableCell( 'modules' );
writableCell( 'templates' );
?>
</table>
</div>
<div class="clr"></div>
</div>
<div class="clr"></div>
</div>
<div class="clr"></div>
</div>
</div>

<div class="ctr">
	<a href="http://www.joomla.org" target="_blank">Joomla</a> is Free Software released under the GNU/GPL License.
</div>

</body>
</html>